#!/usr/bin/env scheme-script
;; -*- mode: scheme; coding: utf-8 -*- !#
;; Copyright (c) 2025 Vadym Kochan
;; SPDX-License-Identifier: MIT
#!r6rs

(import (rnrs (6))
	(conbot))

(conbot-default-timeout 3000)

(define sh (open-conbot-process "/bin/sh" '(("LANG" "C")) ))
(conbot-prompt-set! sh "^sh.*\\$")
(conbot-wait-prompt sh)

(display (conbot-do-shell sh "dd if=/dev/zero of=disk.img bs=4K count=100")) (newline)
(let ([lsout (conbot-do-shell sh "echo $?")])
  (display "exit status: ")(display lsout)(newline))

(conbot-prompt-set! sh "^Command .*: ")

(let ([lsout (conbot-do-shell sh "fdisk disk.img")])
  (display lsout)(newline))

(let ([lsout (conbot-do-shell sh "m")])
  (display lsout)(newline))

(let ([lsout (conbot-do-shell sh "g")])
  (display lsout)(newline))

(conbot-write sh "n\n")
(conbot-wait-prompt sh "^Partition number .*:")
(display (text-row-string (conbot-cursor-row sh))) (newline)
(conbot-write sh "\n")
(conbot-wait-prompt sh "^First sector .*:")
(display (text-row-string (conbot-cursor-row sh))) (newline)
(conbot-write sh "\n")
(conbot-wait-prompt sh "^Last sector .*:")
(display (text-row-string (conbot-cursor-row sh))) (newline)
(conbot-write sh "\n")

(conbot-wait-prompt sh "^Command .*: ")

(conbot-prompt-set! sh "^sh.*\\$")

(let ([lsout (conbot-do-shell sh "w")])
  (display lsout)(newline))

(conbot-write sh "exit\n")
(conbot-close sh)
