;;;; Binary search tree implementation in R6RS Scheme
;;;; Copyright (C)  2025 Nikolaos Chatzikonstantnou
;;;;
;;;; This program is free software: you can redistribute it and/or modify
;;;; it under the terms of the GNU General Public License as published by
;;;; the Free Software Foundation, either version 3 of the License, or
;;;; (at your option) any later version.
;;;;
;;;; This program is distributed in the hope that it will be useful,
;;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;; GNU General Public License for more details.
;;;;
;;;; You should have received a copy of the GNU General Public License
;;;; along with this program.  If not, see <https://www.gnu.org/licenses/>.

;;; Commentary:

;;; Code:

(library (parser elf bstree)
  (export
   ;; bstree record.
   <bstree> make-bstree bstree?
   ;; Accessors.
   bstree-value bstree-left bstree-right
   ;; Conversion.
   vector->bstree)

  (import (rnrs base (6))
          (rnrs records syntactic (6)))

  (define-record-type (<bstree> make-bstree bstree?)
    (fields
     (immutable value bstree-value)
     (immutable left  bstree-left)
     (immutable right bstree-right)))

  (define (vector->bstree v start end)
    "Convert a sorted vector into a balanced binary search tree."
    (let loop ((start start)
               (end end))
      (if (>= start end) '()
          (let ((mid (div (+ end start) 2)))
            (make-bstree (vector-ref v mid)
                         (loop start mid)
                         (loop (+ mid 1) end)))))))
