(library (scheme-langserver analysis identifier primitive-variable)
  (export 
    primitive?
    primitive-content)
  (import 
    (chezscheme)
    (ufo-match)
    (scheme-langserver util contain))

(define (primitive? target)
  (match target
    [('$primitive (? symbol? t)) (ordered-contain? primitive-variables t string<=?)]
    [('$primitive 2 (? symbol? t)) (ordered-contain? primitive-variables t string<=?)]
    [('$primitive 3 (? symbol? t)) (ordered-contain? primitive-variables t string<=?)]
    [else #f]))

(define (primitive-content target)
  (if (primitive? target)
    (car (reverse target))
    '()))
 
(define primitive-variables 
  (sort 
    (lambda (s0 s1) 
      (apply string<=? (map symbol->string `(,s0 ,s1)))) 
'(
$address-in-heap?
$address->object
$allocate-thread-parameter
$app
$app/no-inline
$app/no-return
$app/value
$apply
$assembly-output
$assert-continuation
$as-time-goes-by
$bignum-length
$bigpositive?
$breakhere
$build-install-library/ct-code
$build-install-library/rt-code
$build-invoke-program
$build-library-exts
$byte-copy!
$bytevector-compress
$bytevector-ref-check?
$bytevector-set!-check?
$bytevector-set!
$bytevector-set-immutable!
$bytevector-uncompress
$capture-fasl-target
$c-error
$call-consuming-continuation-attachment
$call-getting-continuation-attachment
$call-setting-continuation-attachment
$call-in-continuation
$char-grapheme-step
$char-grapheme-other-state
$check-heap-errors
$clear-dynamic-closure-counts
$clear-pass-stats
$clear-source-lines-cache
$close-files
$close-resurrected-files
$close-resurrected-mutexes&conditions
$closure-code
$closure-length
$closure-ref
$closure-set!
$c-make-closure
$c-make-code
$code?
$code-free-count
$code-info
$code-arity-mask
$code-mutable-closure?
$code-arity-in-closure?
$code-name
$code-pinfo*
$code-single-valued?
$collect-rendezvous
$compile-backend
$compiled-file-header?
$compile-host-library
$compound-condition-components
$compound-condition?
$compressed-warning
$compute-composition
$compute-size
$constituent?
$constituent-ports
$continuation?
$continuation-link
$continuation-return-code
$continuation-return-frame-words
$continuation-return-livemask
$continuation-return-offset
$continuation-stack-clength
$continuation-stack-length
$continuation-stack-ref
$continuation-stack-return-code
$continuation-stack-return-offset
$continuation-stack-return-frame-words
$continuation-winders
$continuation-attachments
$continuation-marks-first
$cp0
$cpcheck
$cpcheck-prelex-flags
$cpcommonize
$cpletrec
$cptypes
$cpvalid
$c-stlv!
$cte-optimization-info
$c-tlv
$current-attachments
$current-handler-stack
$current-stack-link
$current-winders
$datum->environment-syntax
$dequeue-scheme-signals
$describe-fasl-from-port
$distinct-bound-ids?
$dofmt
$do-wind
$dynamic-closure-counts
$emit-boot-header
$enum-set-members
$eol-style?
$eq-hashtable-cells
$eq-hashtable-clear!
$eq-hashtable-copy
$eq-hashtable-entries
$eq-hashtable-keys
$eq-hashtable-values
$errno
$errno->string
$error-handling-mode?
$event
$event-and-resume
$event-and-resume*
$event-trap-check
$exactnum?
$exactnum-imag-part
$exactnum-real-part
$expand/cte/optimize
$expand/cte
$expand-fp-ftype
$expeditor
$fasl-base-rtd
$fasl-bld-graph
$fasl-can-combine?
$fasl-pbchunk!
$fasl-enter
$fasl-file-equal?
$fasl-out
$fasl-start
$fasl-table
$fasl-to-vfasl
$fasl-wrf-graph
$filter-conv
$filter-foreign-type
$fixed-path?
$fixmediate
$flvector-ref-check?
$flvector-set!-check?
$<=
$<
$=
$-
$/
$*
$+
$fleqv?
$flhash
$flonum->digits
$flonum-exponent
$flonum->fixnum
$flonum-sign
$flush-instruction-cache
$foreign-char?
$foreign-entries
$foreign-entry
$foreign-wchar?
$foreign-swap-ref
$foreign-swap-set!
$format-scheme-version
$fp-filter-type
$fp-string->utf16
$fp-string->utf32
$fp-string->utf8
$fptr-fptr-ref
$fptr-fptr-set!
$fptr-init-lock!
$fptr-locked-decr!
$fptr-locked-incr!
$fptr-lock!
$fptr-offset-addr
$fptr-ref-bits
$fptr-ref-boolean
$fptr-ref-char
$fptr-ref-double-float
$fptr-ref-fixnum
$fptr-&ref
$fptr-ref
$fptr-ref-ibits-swap-unsigned-16
$fptr-ref-ibits-swap-unsigned-24
$fptr-ref-ibits-swap-unsigned-32
$fptr-ref-ibits-swap-unsigned-40
$fptr-ref-ibits-swap-unsigned-48
$fptr-ref-ibits-swap-unsigned-56
$fptr-ref-ibits-swap-unsigned-64
$fptr-ref-ibits-unsigned-16
$fptr-ref-ibits-unsigned-24
$fptr-ref-ibits-unsigned-32
$fptr-ref-ibits-unsigned-40
$fptr-ref-ibits-unsigned-48
$fptr-ref-ibits-unsigned-56
$fptr-ref-ibits-unsigned-64
$fptr-ref-ibits-unsigned-8
$fptr-ref-integer-16
$fptr-ref-integer-24
$fptr-ref-integer-32
$fptr-ref-integer-40
$fptr-ref-integer-48
$fptr-ref-integer-56
$fptr-ref-integer-64
$fptr-ref-integer-8
$fptr-ref-single-float
$fptr-ref-swap-boolean
$fptr-ref-swap-double-float
$fptr-ref-swap-fixnum
$fptr-ref-swap-integer-16
$fptr-ref-swap-integer-24
$fptr-ref-swap-integer-32
$fptr-ref-swap-integer-40
$fptr-ref-swap-integer-48
$fptr-ref-swap-integer-56
$fptr-ref-swap-integer-64
$fptr-ref-swap-single-float
$fptr-ref-swap-unsigned-16
$fptr-ref-swap-unsigned-24
$fptr-ref-swap-unsigned-32
$fptr-ref-swap-unsigned-40
$fptr-ref-swap-unsigned-48
$fptr-ref-swap-unsigned-56
$fptr-ref-swap-unsigned-64
$fptr-ref-swap-wchar
$fptr-ref-ubits-swap-unsigned-16
$fptr-ref-ubits-swap-unsigned-24
$fptr-ref-ubits-swap-unsigned-32
$fptr-ref-ubits-swap-unsigned-40
$fptr-ref-ubits-swap-unsigned-48
$fptr-ref-ubits-swap-unsigned-56
$fptr-ref-ubits-swap-unsigned-64
$fptr-ref-ubits-unsigned-16
$fptr-ref-ubits-unsigned-24
$fptr-ref-ubits-unsigned-32
$fptr-ref-ubits-unsigned-40
$fptr-ref-ubits-unsigned-48
$fptr-ref-ubits-unsigned-56
$fptr-ref-ubits-unsigned-64
$fptr-ref-ubits-unsigned-8
$fptr-ref-unsigned-16
$fptr-ref-unsigned-24
$fptr-ref-unsigned-32
$fptr-ref-unsigned-40
$fptr-ref-unsigned-48
$fptr-ref-unsigned-56
$fptr-ref-unsigned-64
$fptr-ref-unsigned-8
$fptr-ref-wchar
$fptr-set-bits!
$fptr-set-bits-swap-unsigned-16!
$fptr-set-bits-swap-unsigned-24!
$fptr-set-bits-swap-unsigned-32!
$fptr-set-bits-swap-unsigned-40!
$fptr-set-bits-swap-unsigned-48!
$fptr-set-bits-swap-unsigned-56!
$fptr-set-bits-swap-unsigned-64!
$fptr-set-bits-unsigned-16!
$fptr-set-bits-unsigned-24!
$fptr-set-bits-unsigned-32!
$fptr-set-bits-unsigned-40!
$fptr-set-bits-unsigned-48!
$fptr-set-bits-unsigned-56!
$fptr-set-bits-unsigned-64!
$fptr-set-bits-unsigned-8!
$fptr-set-boolean!
$fptr-set-char!
$fptr-set-double-float!
$fptr-set-fixnum!
$fptr-set!
$fptr-set-integer-16!
$fptr-set-integer-24!
$fptr-set-integer-32!
$fptr-set-integer-40!
$fptr-set-integer-48!
$fptr-set-integer-56!
$fptr-set-integer-64!
$fptr-set-integer-8!
$fptr-set-single-float!
$fptr-set-swap-boolean!
$fptr-set-swap-double-float!
$fptr-set-swap-fixnum!
$fptr-set-swap-integer-16!
$fptr-set-swap-integer-24!
$fptr-set-swap-integer-32!
$fptr-set-swap-integer-40!
$fptr-set-swap-integer-48!
$fptr-set-swap-integer-56!
$fptr-set-swap-integer-64!
$fptr-set-swap-single-float!
$fptr-set-swap-unsigned-16!
$fptr-set-swap-unsigned-24!
$fptr-set-swap-unsigned-32!
$fptr-set-swap-unsigned-40!
$fptr-set-swap-unsigned-48!
$fptr-set-swap-unsigned-56!
$fptr-set-swap-unsigned-64!
$fptr-set-swap-wchar!
$fptr-set-unsigned-16!
$fptr-set-unsigned-24!
$fptr-set-unsigned-32!
$fptr-set-unsigned-40!
$fptr-set-unsigned-48!
$fptr-set-unsigned-56!
$fptr-set-unsigned-64!
$fptr-set-unsigned-8!
$fptr-set-wchar!
$fptr-spin-lock!
$fptr-unlock!
$fp-type->pred
$ftd?
$ftd-alignment
$ftd-as-box?
$ftd-atomic-category
$ftd-compound?
$ftd-ffi-encode
$ftd-size
$ftd-union?
$ftd-unsigned?
$ftd->members
$ftype-guardian-oops
$ftype-pointer?
$fxaddress
$fx-? ; not boolean
$fx/
$fx*
$fx+? ; not boolean
$fxu<
$fxvector-ref-check?
$fxvector-set!-check?
$gc-cpu-time
$gc-real-time
$generation
$gensym ; needs immutable strings
$gensym->pretty-name
$get-timer
$guard
$hand-coded
$hashtable-cells
$hashtable-report
$hashtable-size->minlen
$hashtable-veclen
$ht-minlen
$ht-veclen
$immediate?
$impoops
$import-library
$inexactnum?
$inexactnum-imag-part
$inexactnum-real-part
$insert-profile-src!
$install-ftype-guardian
$install-guardian
$install-library-clo-info
$install-library/ct-code
$install-library/ct-desc
$install-library-entry
$install-library/rt-code
$install-library/rt-desc
$install-program-desc
$instantiate-code-object
$integer-16?
$integer-24?
$integer-32?
$integer-40?
$integer-48?
$integer-56?
$integer-64?
$integer-8?
$intern2
$intern3
$intern-gensym
$interpret-backend
$invalid-ftype-index
$invoke-library
$invoke-program
$io-init
$last-new-vector-element
$lexical-error
$library-search
$list-bits-ref
$list-bits-set!
$list-length
$load-library
$loaded-libraries
$locate-source
$logand
$logbit0
$logbit1
$logbit?
$lognot
$logor
$logtest
$logxor
$lookup-library-entry
$loop-unroll-limit
$make-annotation-options
$make-base-modules
$make-binary-input/output-port
$make-binary-input-port
$make-binary-output-port
$make-boot-file
$make-boot-header
$make-cinst
$make-closure
$make-code-object
$make-environment
$make-eq-hashtable
$make-eqhash-vector
$make-exactnum
$make-fasl-strip-options
$make-file-options
$make-fmt->expr
$make-foreign-callable
$make-foreign-procedure
$make-fptr
$make-ftype-guardian
$make-graph-env
$make-library-requirements-options
$make-load-binary
$make-object-finder
$make-phantom-bytevector
$make-promise
$make-read
$make-recompile-condition
$make-record-constructor-descriptor
$make-record-type-descriptor
$make-record-type
$make-relocation-table!
$make-rnrs-libraries
$make-source-oops
$make-src-condition
$make-stencil-vector
$make-empty-stencil-vector
$make-system-stencil-vector
$make-textual-input/output-port
$make-textual-input-port
$make-textual-output-port
$make-tlc
$make-uninitialized-string
$make-vtable
$make-wrapper-procedure
$map
$mark-invoked!
$maybe-compile-file
$mark-pending!
$maybe-seginfo
$noexpand?
$np-boot-code
$np-compile
$np-get-timers
$np-last-pass
$np-reset-timers!
$np-tracer
$np-expand-primitives
$np-next-lambda-seqno
$null-continuation
$object-address
$object-in-heap?
$object-ref ; can't fold since optimize-level 2 version does no checks
$object-set!
$oops/c
$oops
$open-bytevector-list-output-port
$open-file-input/output-port
$open-file-input-port
$open-file-output-port
$open-source-file
$parse-format-string
$pass-stats-fields
$pass-stats
$pass-time
$port-flags-set?
$port-handler
$port-info
$print-pass-stats
$procedure-name
$procedure-realm
$profile-block-data?
$profile-show-database
$profile-source-data?
$ptr-copy!
$quotient-remainder
$ratio-denominator
$ratio-numerator
$raw-collect-cond
$raw-collect-thread0-cond
$raw-tc-mutex
$raw-terminated-cond
$read-performance-monitoring-counter
$read-time-stamp-counter
$real->flonum
$real-sym-name
$recompile-condition?
$recompile-importer-path
$record ; first arg should be an rtd, but we don't check
$record?
$record-cas!
$record-equal-procedure
$record-hash-procedure
$record-oops
$record-ref
$record-set!
$record-type-act-sealed!
$record-type-act-sealed?
$record-type-descriptor
$record-type-field-offsets
$record-type-field-count
$reloc
$remake-rtd
$report-string
$require-include
$require-libraries
$reset-port-flags!
$reset-protect
$revisit
$rtd-counts?
$scheme
$scheme-greeting
$scheme-init
$sc-put-cte
$sc-put-property!
$script
$sealed-record? ; first argument may be not a record
$sealed-record-instance?
$seginfo
$seginfo-generation
$seginfo-space
$separator-character
$set-code-byte!
$set-code-long!
$set-code-quad!
$set-code-word!
$set-collect-trip-bytes
$set-port-flags!
$set-port-info!
$set-symbol-hash!
$set-symbol-name!
$set-symbol-property-list!
$set-system-property-list!
$set-thread-parameter!
$set-timer
$set-tlc-next!
$set-top-level-value!
$sgetprop
$show-allocation
$signal-interrupt-handler
$source-file-descriptor
$source-violation
$source-warning
$spaces
$split-continuation
$sputprop
$src-condition?
$src-condition-src
$src-condition-start
$sremprop
$stencil-vector-fill-set!
$stencil-vector-do-update
$system-stencil-vector-do-update
$system-stencil-vector
$stencil-vector?
$system-stencil-vector?
$stencil-vector-length
$stencil-vector-mask
$stencil-vector-ref
$stencil-vector-set!
$system-stencil-vector-truncate!
$system-stencil-vector-update
$string-char-foldcase
$string-ref-check?
$string-set!-check?
$string-set-immutable!
$str->num
$subsequent?
$swap-object-ref ; can't fold since optimize-level 2 version does no checks
$symbol-hash
$symbol-name
$symbol-property-list
$symbol-type
$syntax-dispatch
$syntax-match?
$syntax->src
$syntax-top-level?
$system-code?
$system-environment
$system-library?
$system-procedure?
$system-property-list
$tc-field
$tc
$thread-list
$thread-tc
$tlc?
$tlc-ht
$tlc-keyval
$tlc-next
$top-level-bound?
$top-level-value
$trace-closure
$trace
$track-dynamic-closure-counts      ; added for closure instrumentation
$track-static-closure-counts ; added for closure instrumentation
$trans-define-ftype
$transformer->binding
$trans-ftype-guardian
$trans-ftype-locked-op!
$trans-ftype-pointer? ; not boolean
$trans-ftype-&ref
$trans-ftype-ref
$trans-ftype-set!
$trans-ftype-sizeof
$trans-make-ftype-pointer
$unbound-object?
$unbound-object
$uncprep ; side-effects preinfo-sexpr, at least
$undefined-violation
$unknown-undefined-violation
$update-mark
$untrace
$unwrap-ftype-pointer
$value
$vector-ref-check?
$vector-set!-check?
$vector-set-immutable!
$verify-ftype-address
$verify-ftype-pointer
$visit
$visit-library
$with-fasl-target
$write-fasl-bytevectors
$write-pretty-quick
$xscript-port?

$annotation-options
$fasl-strip-options
$file-options
$library-requirements-options
$block-counter
$cafe
$compile-profile
$cp0-inner-unroll-limit
$cp0-polyvariant
$current-mso
$enable-check-heap
$enable-check-prelex-flags
$enable-expeditor
$enable-pass-timing
$expeditor-history-file
$fasl-target
$lift-closures
$optimize-closures
$suppress-primitive-inlining
$sfd
$target-machine
$active-threads
$c-bufsiz
$collect-cond
$collect-thread0-cond
$collect-request-pending
$compiler-is-loaded?
$console-error-port
$console-input-port
$console-output-port
$eq-ht-rtd
$heap-reserve-ratio
$interrupt
$nuate
$scheme-version
$session-key
$symbol-ht-rtd
$tc-mutex
$terminated-cond
$&src
$&recompile
$begin-unsafe
$case
$chezscheme-csv7
$foreign-callable
$foreign-procedure
$import
$lambda/lift-barrier
$library
$module
$moi
$program
$rnrs
$rnrs-arithmetic-bitwise
$rnrs-arithmetic-fixnums
$rnrs-arithmetic-flonums
$rnrs-base
$rnrs-bytevectors
$rnrs-conditions
$rnrs-control
$rnrs-enums
$rnrs-eval
$rnrs-exceptions
$rnrs-files
$rnrs-hashtables
$rnrs-io-ports
$rnrs-io-simple
$rnrs-lists
$rnrs-mutable-pairs
$rnrs-mutable-strings
$rnrs-programs
$rnrs-r5rs
$rnrs-records-procedural
$rnrs-records-syntactic
$rnrs-records-inspection
$rnrs-sorting
$rnrs-syntax-case
$rnrs-unicode)))
)