(library (scheme-langserver analysis identifier meta)
  (export 
    construct-type-expression-with-meta
    root-meta-check
    find-meta
    meta-library?)
  (import 
    (rnrs)
    (only (chezscheme) annotation-stripped pretty-print print-graph)
    (ufo-match)
    (scheme-langserver util contain)
    (scheme-langserver util binary-search)
    (scheme-langserver analysis identifier reference)
    (scheme-langserver analysis type substitutions rnrs-meta-rules)

    (scheme-langserver virtual-file-system index-node))

(define initialized? #f)

(define (root-meta-check document index-node target-expression)
  (let* ([expression (annotation-stripped (index-node-datum/annotations index-node))]
      [identifiers (find-available-references-for document index-node (annotation-stripped (index-node-datum/annotations index-node)))]
      [root-identifiers (apply append (map root-ancestor identifiers))])
    (find (lambda (i) (or (meta? i) (equal? (identifier-reference-identifier i) target-expression))) root-identifiers)))

(define (meta-library? list-instance top-environment)
  (contain? 
    (cond 
      [(equal? 'r6rs top-environment) '((rnrs) (scheme) (chezscheme) (rnrs conditions) (rnrs (6)) (rnrs base (6)) (rnrs arithmetic fixnums (6)) 
        (rnrs bytevectors (6)) (rnrs conditions (6)) (rnrs control (6)) (rnrs exceptions (6)) (rnrs hashtables (6)) (rnrs lists (6)) 
        (rnrs mutable-pairs (6)) (rnrs mutable-strings (6)) (rnrs io ports (6)) (rnrs io simple (6)) (rnrs records syntactic (6)) (rnrs unicode (6)) 
        (rnrs base) (rnrs files) (rnrs syntax-case) (rnrs exceptions) (rnrs lists) (rnrs bytevectors) (rnrs control)
        (rnrs unicode) (rnrs enums) (rnrs r5rs) (rnrs eval) (rnrs hashtables) (rnrs sorting) (rnrs programs) (rnrs mutable-pairs) 
        (rnrs mutable-strings) (rnrs io ports) (rnrs io simple) (rnrs arithmetic flonums) (rnrs arithmetic bitwise) (rnrs arithmetic fixnums)
        (rnrs records syntactic) (rnrs records procedural) (rnrs records inspection) (chezscheme csv7) (scheme csv7))]
      [(equal? 'r7rs top-environment) '((scheme base) (scheme case lambda) (scheme char) (scheme complex) (scheme cxr) (scheme eval) (scheme file) (scheme inexact) (scheme lazy)
        (scheme load) (scheme process context) (scheme read) (scheme repl) (scheme time) (scheme write) (scheme r5rs))]
      [(equal? 's7 top-environment) '((scheme base) (scheme case lambda) (scheme char) (scheme complex) (scheme cxr) (scheme eval) (scheme file) (scheme inexact) (scheme lazy)
        (scheme load) (scheme process context) (scheme read) (scheme repl) (scheme time) (scheme write) (scheme r5rs) (s7))]
      [else #f])
    list-instance))

(define find-meta
  (case-lambda
    [(list-instance) (find-meta list-instance 'r6rs)]
    [(list-instance top-environment)
      (if (not initialized?)
        (begin
          (init-type-expressions)
          (set! initialized? #t)))
      (cond
        [(equal? top-environment 'r6rs)
          (cond
            [(equal? list-instance '(rnrs)) rnrs]
            [(equal? list-instance '(scheme)) scheme] 
            [(equal? list-instance '(chezscheme)) chezscheme]
            [(equal? list-instance '(rnrs conditions)) rnrs-conditions]
            ; https://www.gnu.org/software/guile/manual/html_node/rnrs.html
            [(equal? list-instance '(rnrs (6))) rnrs]
            [(equal? list-instance '(rnrs base (6))) rnrs-base]
            [(equal? list-instance '(rnrs arithmetic fixnums (6))) rnrs-arithmetic-fixnums]
            [(equal? list-instance '(rnrs bytevectors (6))) rnrs-bytevectors]
            [(equal? list-instance '(rnrs conditions (6))) rnrs-conditions]
            [(equal? list-instance '(rnrs control (6))) rnrs-control]
            [(equal? list-instance '(rnrs exceptions (6))) rnrs-exceptions]
            [(equal? list-instance '(rnrs hashtables (6))) rnrs-hashtables]
            [(equal? list-instance '(rnrs lists (6))) rnrs-lists]
            [(equal? list-instance '(rnrs mutable-pairs (6))) rnrs-mutable-pairs]
            [(equal? list-instance '(rnrs mutable-strings (6))) rnrs-mutable-strings]
            [(equal? list-instance '(rnrs io ports (6))) rnrs-io-ports]
            [(equal? list-instance '(rnrs io simple (6))) rnrs-io-simple]
            [(equal? list-instance '(rnrs records syntactic (6))) rnrs-records-syntactic]
            [(equal? list-instance '(rnrs unicode (6))) rnrs-unicode]
            [(equal? list-instance '(rnrs base)) rnrs-base]
            [(equal? list-instance '(rnrs files)) rnrs-files]
            [(equal? list-instance '(rnrs syntax-case)) rnrs-syntax-case]
            [(equal? list-instance '(rnrs exceptions)) rnrs-exceptions]
            [(equal? list-instance '(rnrs lists)) rnrs-lists]
            [(equal? list-instance '(rnrs bytevectors)) rnrs-bytevectors]
            [(equal? list-instance '(rnrs control)) rnrs-control]
            [(equal? list-instance '(rnrs unicode)) rnrs-unicode]
            [(equal? list-instance '(rnrs enums)) rnrs-enums]
            [(equal? list-instance '(rnrs r5rs)) rnrs-r5rs]
            [(equal? list-instance '(rnrs eval)) rnrs-eval]
            [(equal? list-instance '(rnrs hashtables)) rnrs-hashtables]
            [(equal? list-instance '(rnrs sorting)) rnrs-sorting]
            [(equal? list-instance '(rnrs programs)) rnrs-programs]
            [(equal? list-instance '(rnrs mutable-pairs)) rnrs-mutable-pairs]
            [(equal? list-instance '(rnrs mutable-strings)) rnrs-mutable-strings]
            [(equal? list-instance '(rnrs io ports)) rnrs-io-ports]
            [(equal? list-instance '(rnrs io simple)) rnrs-io-simple]
            [(equal? list-instance '(rnrs arithmetic flonums)) rnrs-arithmetic-flonums]
            [(equal? list-instance '(rnrs arithmetic bitwise)) rnrs-arithmetic-bitwise]
            [(equal? list-instance '(rnrs arithmetic fixnums)) rnrs-arithmetic-fixnums]
            [(equal? list-instance '(rnrs records syntactic)) rnrs-records-syntactic]
            [(equal? list-instance '(rnrs records procedural)) rnrs-records-procedural]
            [(equal? list-instance '(rnrs records inspection)) rnrs-records-inspection]
            [(equal? list-instance '(chezscheme csv7)) chezscheme-csv7] 
            [(equal? list-instance '(scheme csv7)) scheme-csv7]
            [else '()])]
        [(equal? top-environment 'r7rs) 
          (cond
            [(equal? list-instance '(scheme base)) scheme-base]
            [(equal? list-instance '(scheme case lambda)) scheme-case-lambda]
            [(equal? list-instance '(scheme char)) scheme-char]
            [(equal? list-instance '(scheme complex)) scheme-complex]
            [(equal? list-instance '(scheme cxr)) scheme-cxr]
            [(equal? list-instance '(scheme eval)) scheme-eval]
            [(equal? list-instance '(scheme file)) scheme-file]
            [(equal? list-instance '(scheme inexact)) scheme-inexact]
            [(equal? list-instance '(scheme lazy)) scheme-lazy]
            [(equal? list-instance '(scheme load)) scheme-load]
            [(equal? list-instance '(scheme process context)) scheme-process-context]
            [(equal? list-instance '(scheme read)) scheme-read]
            [(equal? list-instance '(scheme repl)) scheme-repl]
            [(equal? list-instance '(scheme time)) scheme-time]
            [(equal? list-instance '(scheme write)) scheme-write]
            [(equal? list-instance '(scheme r5rs)) scheme-r5rs]
            [else '()])]
        [(equal? top-environment 's7)
          (cond
            [(equal? list-instance '(scheme base)) scheme-base]
            [(equal? list-instance '(scheme case lambda)) scheme-case-lambda]
            [(equal? list-instance '(scheme char)) scheme-char]
            [(equal? list-instance '(scheme complex)) scheme-complex]
            [(equal? list-instance '(scheme cxr)) scheme-cxr]
            [(equal? list-instance '(scheme eval)) scheme-eval]
            [(equal? list-instance '(scheme file)) scheme-file]
            [(equal? list-instance '(scheme inexact)) scheme-inexact]
            [(equal? list-instance '(scheme lazy)) scheme-lazy]
            [(equal? list-instance '(scheme load)) scheme-load]
            [(equal? list-instance '(scheme process context)) scheme-process-context]
            [(equal? list-instance '(scheme read)) scheme-read]
            [(equal? list-instance '(scheme repl)) scheme-repl]
            [(equal? list-instance '(scheme time)) scheme-time]
            [(equal? list-instance '(scheme write)) scheme-write]
            [(equal? list-instance '(scheme r5rs)) scheme-r5rs]
            [(equal? list-instance '(s7)) s7]
            [else '()])]
        [else '()])]))

(define private-process
  (case-lambda
    [(library-instance list-instance) (private-process library-instance list-instance 'r6rs)]
    [(library-instance list-instance top-environment)
      (sort-identifier-references 
        (map 
            (lambda (identifier-pair) 
              (make-identifier-reference (car identifier-pair) '() '() '() library-instance (cadr identifier-pair) '() '() top-environment))
            list-instance))]))

(define (init-type-expressions)
  (map 
    (lambda (list-instance)
      (map 
        (lambda (identifier-reference)
          (identifier-reference-type-expressions-set!
            identifier-reference
            (private-construct-type-expression-with-meta 
              (map 
                cadr
                (binary-search
                  (list->vector rnrs-chez-rules)
                  (lambda (target0 target1)
                    (string<=? 
                      (symbol->string (car target0))
                      (symbol->string (car target1))))
                  (list (identifier-reference-identifier identifier-reference))))
              chezscheme)))
        list-instance))
    (list rnrs scheme chezscheme rnrs-conditions rnrs-base 
rnrs-files rnrs-syntax-case rnrs-exceptions rnrs-lists 
rnrs-bytevectors rnrs-control rnrs-unicode rnrs-enums 
rnrs-r5rs rnrs-eval rnrs-hashtables rnrs-sorting 
rnrs-programs rnrs-mutable-pairs rnrs-mutable-strings 
rnrs-io-ports rnrs-io-simple rnrs-arithmetic-flonums 
rnrs-arithmetic-bitwise rnrs-arithmetic-fixnums 
rnrs-records-syntactic rnrs-records-procedural
rnrs-records-inspection chezscheme-csv7 scheme-csv7
scheme-base scheme-case-lambda scheme-char scheme-complex
scheme-cxr scheme-eval scheme-file scheme-inexact scheme-lazy 
scheme-load scheme-process-context scheme-read scheme-repl 
scheme-time scheme-write scheme-r5rs s7))
  ;numeric tower
  (fold-left 
    (lambda (parent identifier-reference)
        (identifier-reference-parents-set! identifier-reference (list parent))
        identifier-reference)
    (find (lambda (identifier-reference) (equal? 'fixnum? (identifier-reference-identifier identifier-reference))) chezscheme)
    (map 
        (lambda (procedure-name) 
          (find 
              (lambda (identifier-reference) 
                (equal? procedure-name (identifier-reference-identifier identifier-reference))) chezscheme)) 
        '(bignum? integer? cflonum? flonum? rational? real? complex? number?))))

(define (construct-type-expression-with-meta expression)
  (if (not initialized?)
    (begin
      (init-type-expressions)
      (set! initialized? #t)))
  ;;chezscheme is the super set of rnrs
  (private-construct-type-expression-with-meta expression chezscheme))

(define (private-construct-type-expression-with-meta expression list-instance)
  (match expression
    [(? index-node? fuzzy) fuzzy]
    [('inner:list? fuzzy ...) `(inner:list? ,@(map (lambda(target) (private-construct-type-expression-with-meta target list-instance)) fuzzy))]
    [('inner:vector? fuzzy ...) `(inner:vector? ,@(map (lambda(target) (private-construct-type-expression-with-meta target list-instance)) fuzzy))]
    [('inner:pair? fuzzy ...) `(inner:pair? ,@(map (lambda(target) (private-construct-type-expression-with-meta target list-instance)) fuzzy))]
    [(fuzzy0 '<- fuzzy1) `(,(private-construct-type-expression-with-meta fuzzy0 list-instance) <- ,(private-construct-type-expression-with-meta fuzzy1 list-instance))]
    [(head **1) (map (lambda (expression) (private-construct-type-expression-with-meta expression list-instance)) expression)]
    [(? symbol? meta-identifier)
      (cond 
        [(equal? meta-identifier '<-) '<-]
        [(equal? meta-identifier '...) '...]
        [(equal? meta-identifier '**1) '**1]
        [(equal? meta-identifier 'something?) 'something?]
        [(equal? meta-identifier 'void?) 'void?]
        [else
          (let ([target-identifier (find (lambda(x) (equal? (identifier-reference-identifier x) meta-identifier)) list-instance)])
            (if target-identifier target-identifier meta-identifier))])]
    [() '()]))

(define rnrs (private-process '(rnrs) '(
(&assertion	syntax)
(&condition	syntax)
(&error	syntax)
(&i/o	syntax)
(&i/o-decoding	syntax)
(&i/o-encoding	syntax)
(&i/o-file-already-exists	syntax)
(&i/o-file-does-not-exist	syntax)
(&i/o-file-is-read-only	syntax)
(&i/o-file-protection	syntax)
(&i/o-filename	syntax)
(&i/o-invalid-position	syntax)
(&i/o-port	syntax)
(&i/o-read	syntax)
(&i/o-write	syntax)
(&implementation-restriction	syntax)
(&irritants	syntax)
(&lexical	syntax)
(&message	syntax)
(&no-infinities	syntax)
(&no-nans	syntax)
(&non-continuable	syntax)
(&serious	syntax)
(&syntax	syntax)
(&undefined	syntax)
(&violation	syntax)
(&warning	syntax)
(&who	syntax)
(*	procedure)
(+	procedure)
(-	procedure)
(...	syntax)
(/	procedure)
(=>	syntax)
(_	syntax)
(abs	procedure)
(acos	procedure)
(and	syntax)
(angle	procedure)
(append	procedure)
(apply	procedure)
(asin	procedure)
(assert	syntax)
(assertion-violation	procedure)
(assertion-violation?	procedure)
(assoc	procedure)
(assp	procedure)
(assq	procedure)
(assv	procedure)
(atan	procedure)
(begin	syntax)
(binary-port?	procedure)
(bitwise-and	procedure)
(bitwise-arithmetic-shift	procedure)
(bitwise-arithmetic-shift-left	procedure)
(bitwise-arithmetic-shift-right	procedure)
(bitwise-bit-count	procedure)
(bitwise-bit-field	procedure)
(bitwise-bit-set?	procedure)
(bitwise-copy-bit	procedure)
(bitwise-copy-bit-field	procedure)
(bitwise-first-bit-set	procedure)
(bitwise-if	procedure)
(bitwise-ior	procedure)
(bitwise-length	procedure)
(bitwise-not	procedure)
(bitwise-reverse-bit-field	procedure)
(bitwise-rotate-bit-field	procedure)
(bitwise-xor	procedure)
(boolean=?	procedure)
(boolean?	procedure)
(bound-identifier=?	procedure)
(buffer-mode	syntax)
(buffer-mode?	syntax)
(bytevector->sint-list	procedure)
(bytevector->string	procedure)
(bytevector->u8-list	procedure)
(bytevector->uint-list	procedure)
(bytevector-copy	procedure)
(bytevector-copy!	procedure)
(bytevector-fill!	procedure)
(bytevector-ieee-double-native-ref	procedure)
(bytevector-ieee-double-native-set!	procedure)
(bytevector-ieee-double-ref	procedure)
(bytevector-ieee-double-set!	procedure)
(bytevector-ieee-single-native-ref	procedure)
(bytevector-ieee-single-native-set!	procedure)
(bytevector-ieee-single-ref	procedure)
(bytevector-ieee-single-set!	procedure)
(bytevector-length	procedure)
(bytevector-s16-native-ref	procedure)
(bytevector-s16-native-set!	procedure)
(bytevector-s16-ref	procedure)
(bytevector-s16-set!	procedure)
(bytevector-s32-native-ref	procedure)
(bytevector-s32-native-set!	procedure)
(bytevector-s32-ref	procedure)
(bytevector-s32-set!	procedure)
(bytevector-s64-native-ref	procedure)
(bytevector-s64-native-set!	procedure)
(bytevector-s64-ref	procedure)
(bytevector-s64-set!	procedure)
(bytevector-s8-ref	procedure)
(bytevector-s8-set!	procedure)
(bytevector-sint-ref	procedure)
(bytevector-sint-set!	procedure)
(bytevector-u16-native-ref	procedure)
(bytevector-u16-native-set!	procedure)
(bytevector-u16-ref	procedure)
(bytevector-u16-set!	procedure)
(bytevector-u32-native-ref	procedure)
(bytevector-u32-native-set!	procedure)
(bytevector-u32-ref	procedure)
(bytevector-u32-set!	procedure)
(bytevector-u64-native-ref	procedure)
(bytevector-u64-native-set!	procedure)
(bytevector-u64-ref	procedure)
(bytevector-u64-set!	procedure)
(bytevector-u8-ref	procedure)
(bytevector-u8-set!	procedure)
(bytevector-uint-ref	procedure)
(bytevector-uint-set!	procedure)
(bytevector=?	procedure)
(bytevector?	procedure)
(caaaar	procedure)
(caaadr	procedure)
(caaar	procedure)
(caadar	procedure)
(caaddr	procedure)
(caadr	procedure)
(caar	procedure)
(cadaar	procedure)
(cadadr	procedure)
(cadar	procedure)
(caddar	procedure)
(cadddr	procedure)
(caddr	procedure)
(cadr	procedure)
(call-with-bytevector-output-port	procedure)
(call-with-current-continuation	procedure)
(call-with-port	procedure)
(call-with-string-output-port	procedure)
(call-with-values	procedure)
(call/cc	procedure)
(car	procedure)
(case-lambda	syntax)
(cdaaar	procedure)
(cdaadr	procedure)
(cdaar	procedure)
(cdadar	procedure)
(cdaddr	procedure)
(cdadr	procedure)
(cdar	procedure)
(cddaar	procedure)
(cddadr	procedure)
(cddar	procedure)
(cdddar	procedure)
(cddddr	procedure)
(cdddr	procedure)
(cddr	procedure)
(cdr	procedure)
(ceiling	procedure)
(char->integer	procedure)
(char-alphabetic?	procedure)
(char-downcase	procedure)
(char-foldcase	procedure)
(char-general-category	procedure)
(char-lower-case?	procedure)
(char-numeric?	procedure)
(char-title-case?	procedure)
(char-titlecase	procedure)
(char-upcase	procedure)
(char-upper-case?	procedure)
(char-whitespace?	procedure)
(char?	procedure)
(close-input-port	procedure)
(close-output-port	procedure)
(close-port	procedure)
(complex?	procedure)
(cond	syntax)
(condition	procedure)
(condition-accessor	procedure)
(condition-irritants	procedure)
(condition-message	procedure)
(condition-predicate	procedure)
(condition-who	procedure)
(condition?	procedure)
(cons	procedure)
(cons*	procedure)
(cos	procedure)
(datum->syntax	procedure)
(define	syntax)
(define-condition-type	syntax)
(define-enumeration	syntax)
(define-record-type	syntax)
(define-syntax	syntax)
(denominator	procedure)
(display	procedure)
(div	procedure)
(div-and-mod	procedure)
(div0	procedure)
(div0-and-mod0	procedure)
(do	syntax)
(else	syntax)
(endianness	syntax)
(enum-set->list	procedure)
(enum-set-complement	procedure)
(enum-set-constructor	procedure)
(enum-set-difference	procedure)
(enum-set-indexer	procedure)
(enum-set-intersection	procedure)
(enum-set-member?	procedure)
(enum-set-projection	procedure)
(enum-set-subset?	procedure)
(enum-set-union	procedure)
(enum-set-universe	procedure)
(enum-set=?	procedure)
(eof-object	procedure)
(eof-object?	procedure)
(eol-style	syntax)
(eq?	procedure)
(equal-hash	procedure)
(equal?	procedure)
(eqv?	procedure)
(error	procedure)
(error-handling-mode	syntax)
(error?	procedure)
(even?	procedure)
(exact	procedure)
(exact-integer-sqrt	procedure)
(exact?	procedure)
(exists	procedure)
(exp	procedure)
(expt	procedure)
(fields	syntax)
(file-options	syntax)
(filter	procedure)
(find	procedure)
(finite?	procedure)
(fixnum->flonum	procedure)
(fixnum-width	procedure)
(fixnum?	procedure)
(fl*	procedure)
(fl+	procedure)
(fl-	procedure)
(fl/	procedure)
(fl<=?	procedure)
(fl<?	procedure)
(fl=?	procedure)
(fl>=?	procedure)
(fl>?	procedure)
(flabs	procedure)
(flacos	procedure)
(flasin	procedure)
(flatan	procedure)
(flceiling	procedure)
(flcos	procedure)
(fldenominator	procedure)
(fldiv	procedure)
(fldiv-and-mod	procedure)
(fldiv0	procedure)
(fldiv0-and-mod0	procedure)
(fleven?	procedure)
(flexp	procedure)
(flexpt	procedure)
(flfinite?	procedure)
(flfloor	procedure)
(flinfinite?	procedure)
(flinteger?	procedure)
(fllog	procedure)
(flmax	procedure)
(flmin	procedure)
(flmod	procedure)
(flmod0	procedure)
(flnan?	procedure)
(flnegative?	procedure)
(flnumerator	procedure)
(flodd?	procedure)
(flonum?	procedure)
(floor	procedure)
(flpositive?	procedure)
(flround	procedure)
(flsin	procedure)
(flsqrt	procedure)
(fltan	procedure)
(fltruncate	procedure)
(flzero?	procedure)
(fold-left	procedure)
(fold-right	procedure)
(for-all	procedure)
(for-each	procedure)
(free-identifier=?	procedure)
(fx*/carry	procedure)
(fx+/carry	procedure)
(fx-/carry	procedure)
(fx<=?	procedure)
(fx<?	procedure)
(fx=?	procedure)
(fx>=?	procedure)
(fx>?	procedure)
(fxand	procedure)
(fxarithmetic-shift	procedure)
(fxarithmetic-shift-left	procedure)
(fxarithmetic-shift-right	procedure)
(fxbit-count	procedure)
(fxbit-field	procedure)
(fxbit-set?	procedure)
(fxcopy-bit	procedure)
(fxcopy-bit-field	procedure)
(fxdiv	procedure)
(fxdiv-and-mod	procedure)
(fxdiv0	procedure)
(fxdiv0-and-mod0	procedure)
(fxeven?	procedure)
(fxfirst-bit-set	procedure)
(fxif	procedure)
(fxior	procedure)
(fxlength	procedure)
(fxmax	procedure)
(fxmin	procedure)
(fxmod	procedure)
(fxmod0	procedure)
(fxnegative?	procedure)
(fxnot	procedure)
(fxodd?	procedure)
(fxpositive?	procedure)
(fxreverse-bit-field	procedure)
(fxrotate-bit-field	procedure)
(fxxor	procedure)
(fxzero?	procedure)
(gcd	procedure)
(generate-temporaries	procedure)
(get-bytevector-all	procedure)
(get-bytevector-n	procedure)
(get-bytevector-n!	procedure)
(get-bytevector-some	procedure)
(get-char	procedure)
(get-datum	procedure)
(get-line	procedure)
(get-string-all	procedure)
(get-string-n	procedure)
(get-string-n!	procedure)
(get-u8	procedure)
(greatest-fixnum	procedure)
(guard	syntax)
(hashtable-clear!	procedure)
(hashtable-contains?	procedure)
(hashtable-copy	procedure)
(hashtable-delete!	procedure)
(hashtable-equivalence-function	procedure)
(hashtable-hash-function	procedure)
(hashtable-mutable?	procedure)
(hashtable-ref	procedure)
(hashtable-set!	procedure)
(hashtable-size	procedure)
(hashtable-update!	procedure)
(hashtable?	procedure)
(i/o-decoding-error?	procedure)
(i/o-encoding-error-char	procedure)
(i/o-encoding-error?	procedure)
(i/o-error-filename	procedure)
(i/o-error-port	procedure)
(i/o-error-position	procedure)
(i/o-error?	procedure)
(i/o-file-already-exists-error?	procedure)
(i/o-file-does-not-exist-error?	procedure)
(i/o-file-is-read-only-error?	procedure)
(i/o-file-protection-error?	procedure)
(i/o-filename-error?	procedure)
(i/o-invalid-position-error?	procedure)
(i/o-port-error?	procedure)
(i/o-read-error?	procedure)
(i/o-write-error?	procedure)
(identifier-syntax	syntax)
(identifier?	procedure)
(if	syntax)
(imag-part	procedure)
(immutable	syntax)
(implementation-restriction-violation?	procedure)
(inexact	procedure)
(inexact?	procedure)
(infinite?	procedure)
(input-port?	procedure)
(integer->char	procedure)
(integer-valued?	procedure)
(integer?	procedure)
(irritants-condition?	procedure)
(lambda	syntax)
(latin-1-codec	procedure)
(lcm	procedure)
(least-fixnum	procedure)
(length	procedure)
(let	syntax)
(let*	syntax)
(let*-values	syntax)
(let-syntax	syntax)
(let-values	syntax)
(letrec	syntax)
(letrec*	syntax)
(letrec-syntax	syntax)
(lexical-violation?	procedure)
(list	procedure)
(list->string	procedure)
(list->vector	procedure)
(list-ref	procedure)
(list-sort	procedure)
(list-tail	procedure)
(list?	procedure)
(log	procedure)
(lookahead-char	procedure)
(lookahead-u8	procedure)
(magnitude	procedure)
(make-assertion-violation	procedure)
(make-bytevector	procedure)
(make-custom-binary-input-port	procedure)
(make-custom-binary-input/output-port	procedure)
(make-custom-binary-output-port	procedure)
(make-custom-textual-input-port	procedure)
(make-custom-textual-input/output-port	procedure)
(make-custom-textual-output-port	procedure)
(make-enumeration	procedure)
(make-eq-hashtable	procedure)
(make-eqv-hashtable	procedure)
(make-error	procedure)
(make-hashtable	procedure)
(make-i/o-decoding-error	procedure)
(make-i/o-encoding-error	procedure)
(make-i/o-error	procedure)
(make-i/o-file-already-exists-error	procedure)
(make-i/o-file-does-not-exist-error	procedure)
(make-i/o-file-is-read-only-error	procedure)
(make-i/o-file-protection-error	procedure)
(make-i/o-filename-error	procedure)
(make-i/o-invalid-position-error	procedure)
(make-i/o-port-error	procedure)
(make-i/o-read-error	procedure)
(make-i/o-write-error	procedure)
(make-implementation-restriction-violation	procedure)
(make-irritants-condition	procedure)
(make-lexical-violation	procedure)
(make-message-condition	procedure)
(make-no-infinities-violation	procedure)
(make-no-nans-violation	procedure)
(make-non-continuable-violation	procedure)
(make-polar	procedure)
(make-record-constructor-descriptor	procedure)
(make-record-type-descriptor	procedure)
(make-rectangular	procedure)
(make-serious-condition	procedure)
(make-string	procedure)
(make-syntax-violation	procedure)
(make-transcoder	procedure)
(make-undefined-violation	procedure)
(make-variable-transformer	procedure)
(make-vector	procedure)
(make-violation	procedure)
(make-warning	procedure)
(make-who-condition	procedure)
(map	procedure)
(max	procedure)
(member	procedure)
(memp	procedure)
(memq	procedure)
(memv	procedure)
(message-condition?	procedure)
(min	procedure)
(mod	procedure)
(mod0	procedure)
(mutable	syntax)
(nan?	procedure)
(native-endianness	procedure)
(native-eol-style	procedure)
(native-transcoder	procedure)
(negative?	procedure)
(newline	procedure)
(no-infinities-violation?	procedure)
(no-nans-violation?	procedure)
(non-continuable-violation?	procedure)
(nongenerative	syntax)
(not	procedure)
(null?	procedure)
(number?	procedure)
(numerator	procedure)
(odd?	procedure)
(opaque	syntax)
(open-bytevector-input-port	procedure)
(open-bytevector-output-port	procedure)
(open-file-input-port	procedure)
(open-file-input/output-port	procedure)
(open-file-output-port	procedure)
(open-string-input-port	procedure)
(open-string-output-port	procedure)
(or	syntax)
(output-port-buffer-mode	procedure)
(output-port?	procedure)
(pair?	procedure)
(parent	syntax)
(parent-rtd	syntax)
(partition	procedure)
(peek-char	procedure)
(port-eof?	procedure)
(port-has-port-position?	procedure)
(port-has-set-port-position!?	procedure)
(port-position	procedure)
(port-transcoder	procedure)
(port?	procedure)
(positive?	procedure)
(procedure?	procedure)
(protocol	syntax)
(put-bytevector	procedure)
(put-char	procedure)
(put-datum	procedure)
(put-string	procedure)
(put-u8	procedure)
(quasiquote	syntax)
(quasisyntax	syntax)
(quote	syntax)
(<	procedure)
(<=	procedure)
(=	procedure)
(>	procedure)
(>=	procedure)
(call-with-input-file	procedure)
(call-with-output-file	procedure)
(case	syntax)
(char-ci<=?	procedure)
(char-ci<?	procedure)
(char-ci=?	procedure)
(char-ci>=?	procedure)
(char-ci>?	procedure)
(char<=?	procedure)
(char<?	procedure)
(char=?	procedure)
(char>=?	procedure)
(char>?	procedure)
(command-line	global-param)
(current-error-port	thread-param)
(current-input-port	thread-param)
(current-output-port	thread-param)
(delete-file	procedure)
(dynamic-wind	procedure)
(exit	procedure)
(file-exists?	procedure)
(flush-output-port	procedure)
(fx*	procedure)
(fx+	procedure)
(fx-	procedure)
(hashtable-entries	procedure)
(hashtable-keys	procedure)
(number->string	procedure)
(open-input-file	procedure)
(open-output-file	procedure)
(record-constructor	procedure)
(record?	procedure)
(standard-error-port	procedure)
(standard-input-port	procedure)
(standard-output-port	procedure)
(string->number	procedure)
(string-ci<=?	procedure)
(string-ci<?	procedure)
(string-ci=?	procedure)
(string-ci>=?	procedure)
(string-ci>?	procedure)
(string<=?	procedure)
(string<?	procedure)
(string=?	procedure)
(string>=?	procedure)
(string>?	procedure)
(syntax-rules	syntax)
(utf-16-codec	procedure)
(with-input-from-file	procedure)
(with-output-to-file	procedure)
(raise	procedure)
(raise-continuable	procedure)
(rational-valued?	procedure)
(rational?	procedure)
(rationalize	procedure)
(read	procedure)
(read-char	procedure)
(real->flonum	procedure)
(real-part	procedure)
(real-valued?	procedure)
(real?	procedure)
(record-accessor	procedure)
(record-constructor-descriptor	syntax)
(record-field-mutable?	procedure)
(record-mutator	procedure)
(record-predicate	procedure)
(record-rtd	procedure)
(record-type-descriptor	procedure)
(record-type-descriptor?	procedure)
(record-type-field-names	procedure)
(record-type-generative?	procedure)
(record-type-name	procedure)
(record-type-opaque?	procedure)
(record-type-parent	procedure)
(record-type-sealed?	procedure)
(record-type-uid	procedure)
(remove	procedure)
(remp	procedure)
(remq	procedure)
(remv	procedure)
(reverse	procedure)
(round	procedure)
(sealed	syntax)
(serious-condition?	procedure)
(set!	syntax)
(set-port-position!	procedure)
(simple-conditions	procedure)
(sin	procedure)
(sint-list->bytevector	procedure)
(sqrt	procedure)
(string	procedure)
(string->bytevector	procedure)
(string->list	procedure)
(string->symbol	procedure)
(string->utf16	procedure)
(string->utf32	procedure)
(string->utf8	procedure)
(string-append	procedure)
(string-ci-hash	procedure)
(string-copy	procedure)
(string-downcase	procedure)
(string-foldcase	procedure)
(string-for-each	procedure)
(string-hash	procedure)
(string-length	procedure)
(string-normalize-nfc	procedure)
(string-normalize-nfd	procedure)
(string-normalize-nfkc	procedure)
(string-normalize-nfkd	procedure)
(string-ref	procedure)
(string-titlecase	procedure)
(string-upcase	procedure)
(string?	procedure)
(substring	procedure)
(symbol->string	procedure)
(symbol-hash	procedure)
(symbol=?	procedure)
(symbol?	procedure)
(syntax	syntax)
(syntax->datum	procedure)
(syntax-case	syntax)
(syntax-violation	procedure)
(syntax-violation-form	procedure)
(syntax-violation-subform	procedure)
(syntax-violation?	procedure)
(tan	procedure)
(textual-port?	procedure)
(transcoded-port	procedure)
(transcoder-codec	procedure)
(transcoder-eol-style	procedure)
(transcoder-error-handling-mode	procedure)
(truncate	procedure)
(u8-list->bytevector	procedure)
(uint-list->bytevector	procedure)
(undefined-violation?	procedure)
(unless	syntax)
(unquote	syntax)
(unquote-splicing	syntax)
(unsyntax	syntax)
(unsyntax-splicing	syntax)
(utf-8-codec	procedure)
(utf16->string	procedure)
(utf32->string	procedure)
(utf8->string	procedure)
(values	procedure)
(vector	procedure)
(vector->list	procedure)
(vector-fill!	procedure)
(vector-for-each	procedure)
(vector-length	procedure)
(vector-map	procedure)
(vector-ref	procedure)
(vector-set!	procedure)
(vector-sort	procedure)
(vector-sort!	procedure)
(vector?	procedure)
(violation?	procedure)
(warning?	procedure)
(when	syntax)
(who-condition?	procedure)
(with-exception-handler	procedure)
(with-syntax	syntax)
(write	procedure)
(write-char	procedure)
(zero?	procedure))))

(define scheme (private-process '(scheme) '(
(- procedure)
($primitive syntax)
($system module)
(&assertion syntax)
(&condition syntax)
(&continuation syntax)
(&error syntax)
(&format syntax)
(&i/o syntax)
(&i/o-decoding syntax)
(&i/o-encoding syntax)
(&i/o-file-already-exists syntax)
(&i/o-file-does-not-exist syntax)
(&i/o-file-is-read-only syntax)
(&i/o-filename syntax)
(&i/o-file-protection syntax)
(&i/o-invalid-position syntax)
(&i/o-port syntax)
(&i/o-read syntax)
(&i/o-write syntax)
(&implementation-restriction syntax)
(&irritants syntax)
(&lexical syntax)
(&message syntax)
(&no-infinities syntax)
(&no-nans syntax)
(&non-continuable syntax)
(&serious syntax)
(&source syntax)
(&syntax syntax)
(&undefined syntax)
(&violation syntax)
(&warning syntax)
(&who syntax)
(* procedure)
(... syntax)
(/ procedure)
(_ syntax)
(+ procedure)
(+ procedure)
(< procedure)
(<= procedure)
(= procedure)
(=> syntax)
(> procedure)
(>= procedure)
; (1+ procedure)
(abort procedure-skipped)
(abort-handler thread-param)
(abs procedure)
(acos procedure)
(acosh procedure)
(add1 procedure)
(add-duration procedure)
(add-duration! procedure)
(add-prefix syntax)
(alias syntax)
(and syntax)
(andmap procedure)
(angle procedure)
(annotation? procedure)
(annotation-expression procedure)
(annotation-options procedure)
(annotation-option-set syntax)
(annotation-source procedure)
(annotation-stripped procedure)
(append procedure)
(append! procedure)
(apply procedure)
(apropos procedure)
(apropos-list procedure)
(ash procedure)
(asin procedure)
(asinh procedure)
(assert syntax)
(assertion-violation procedure)
(assertion-violation? procedure)
(assertion-violationf procedure)
(assoc procedure)
(assp procedure)
(assq procedure)
(assv procedure)
(atan procedure)
(atanh procedure)
(atom? procedure)
(base-exception-handler thread-param)
(begin syntax)
(bignum? procedure)
(binary-port? procedure)
(binary-port-input-buffer procedure)
(binary-port-input-count procedure)
(binary-port-input-index procedure)
(binary-port-input-size procedure)
(binary-port-output-buffer procedure)
(binary-port-output-count procedure)
(binary-port-output-index procedure)
(binary-port-output-size procedure)
(bitwise-and procedure)
(bitwise-arithmetic-shift procedure)
(bitwise-arithmetic-shift-left procedure)
(bitwise-arithmetic-shift-right procedure)
(bitwise-bit-count procedure)
(bitwise-bit-field procedure)
(bitwise-bit-set? procedure)
(bitwise-copy-bit procedure)
(bitwise-copy-bit-field procedure)
(bitwise-first-bit-set procedure)
(bitwise-if procedure)
(bitwise-ior procedure)
(bitwise-length procedure)
(bitwise-not procedure)
(bitwise-reverse-bit-field procedure)
(bitwise-rotate-bit-field procedure)
(bitwise-xor procedure)
(block-read procedure)
(block-write procedure)
(boolean? procedure)
(boolean=? procedure)
(bound-identifier=? procedure)
(box procedure)
(box? procedure)
(box-cas! procedure)
(box-immutable procedure)
(break procedure)
(break-handler thread-param)
(buffer-mode syntax)
(buffer-mode? syntax)
(bwp-object? procedure)
(bytes-allocated procedure)
(bytes-deallocated procedure)
(bytevector procedure)
(bytevector? procedure)
(bytevector=? procedure)
(bytevector->immutable-bytevector procedure)
(bytevector->s8-list procedure)
(bytevector->sint-list procedure)
(bytevector->string procedure)
(bytevector->u8-list procedure)
(bytevector->uint-list procedure)
(bytevector-compress procedure)
(bytevector-copy procedure)
(bytevector-copy! procedure)
(bytevector-fill! procedure)
(bytevector-ieee-double-native-ref procedure)
(bytevector-ieee-double-native-set! procedure)
(bytevector-ieee-double-ref procedure)
(bytevector-ieee-double-set! procedure)
(bytevector-ieee-single-native-ref procedure)
(bytevector-ieee-single-native-set! procedure)
(bytevector-ieee-single-ref procedure)
(bytevector-ieee-single-set! procedure)
(bytevector-length procedure)
(bytevector-s16-native-ref procedure)
(bytevector-s16-native-set! procedure)
(bytevector-s16-ref procedure)
(bytevector-s16-set! procedure)
(bytevector-s24-ref procedure)
(bytevector-s24-set! procedure)
(bytevector-s32-native-ref procedure)
(bytevector-s32-native-set! procedure)
(bytevector-s32-ref procedure)
(bytevector-s32-set! procedure)
(bytevector-s40-ref procedure)
(bytevector-s40-set! procedure)
(bytevector-s48-ref procedure)
(bytevector-s48-set! procedure)
(bytevector-s56-ref procedure)
(bytevector-s56-set! procedure)
(bytevector-s64-native-ref procedure)
(bytevector-s64-native-set! procedure)
(bytevector-s64-ref procedure)
(bytevector-s64-set! procedure)
(bytevector-s8-ref procedure)
(bytevector-s8-set! procedure)
(bytevector-sint-ref procedure)
(bytevector-sint-set! procedure)
(bytevector-truncate! procedure)
(bytevector-u16-native-ref procedure)
(bytevector-u16-native-set! procedure)
(bytevector-u16-ref procedure)
(bytevector-u16-set! procedure)
(bytevector-u24-ref procedure)
(bytevector-u24-set! procedure)
(bytevector-u32-native-ref procedure)
(bytevector-u32-native-set! procedure)
(bytevector-u32-ref procedure)
(bytevector-u32-set! procedure)
(bytevector-u40-ref procedure)
(bytevector-u40-set! procedure)
(bytevector-u48-ref procedure)
(bytevector-u48-set! procedure)
(bytevector-u56-ref procedure)
(bytevector-u56-set! procedure)
(bytevector-u64-native-ref procedure)
(bytevector-u64-native-set! procedure)
(bytevector-u64-ref procedure)
(bytevector-u64-set! procedure)
(bytevector-u8-ref procedure)
(bytevector-u8-set! procedure)
(bytevector-uint-ref procedure)
(bytevector-uint-set! procedure)
(bytevector-uncompress procedure)
(caaaar procedure)
(caaadr procedure)
(caaar procedure)
(caadar procedure)
(caaddr procedure)
(caadr procedure)
(caar procedure)
(cadaar procedure)
(cadadr procedure)
(cadar procedure)
(caddar procedure)
(cadddr procedure)
(caddr procedure)
(cadr procedure)
(call/1cc procedure)
(call/cc procedure)
(call-with-bytevector-output-port procedure)
(call-with-current-continuation procedure)
(call-with-input-file procedure)
(call-with-output-file procedure)
(call-with-port procedure)
(call-with-string-output-port procedure)
(call-with-values procedure)
(car procedure)
(case syntax)
(case-lambda syntax)
(case-sensitive thread-param)
(cd global-param)
(cdaaar procedure)
(cdaadr procedure)
(cdaar procedure)
(cdadar procedure)
(cdaddr procedure)
(cdadr procedure)
(cdar procedure)
(cddaar procedure)
(cddadr procedure)
(cddar procedure)
(cdddar procedure)
(cddddr procedure)
(cdddr procedure)
(cddr procedure)
(cdr procedure)
(ceiling procedure)
(cfl- procedure)
(cfl* procedure)
(cfl/ procedure)
(cfl+ procedure)
(cfl= procedure)
(cfl-conjugate procedure)
(cfl-imag-part procedure)
(cfl-magnitude-squared procedure)
(cflonum? procedure)
(cfl-real-part procedure)
(char- procedure)
(char? procedure)
(char<? procedure)
(char<=? procedure)
(char=? procedure)
(char>? procedure)
(char>=? procedure)
(char->integer procedure)
(char-alphabetic? procedure)
(char-ci<? procedure)
(char-ci<=? procedure)
(char-ci=? procedure)
(char-ci>? procedure)
(char-ci>=? procedure)
(char-downcase procedure)
(char-foldcase procedure)
(char-general-category procedure)
(char-lower-case? procedure)
(char-name procedure)
(char-numeric? procedure)
(char-ready? procedure)
(char-titlecase procedure)
(char-title-case? procedure)
(char-upcase procedure)
(char-upper-case? procedure)
(char-whitespace? procedure)
(chmod procedure)
(clear-input-port procedure)
(clear-output-port procedure)
(close-input-port procedure)
(close-output-port procedure)
(close-port procedure)
(collect procedure)
(collect-generation-radix global-param)
(collections procedure)
(collect-maximum-generation global-param)
(collect-notify global-param)
(collect-rendezvous procedure)
(collect-request-handler global-param)
(collect-trip-bytes global-param)
(command-line global-param)
(command-line-arguments global-param)
(commonization-level thread-param)
(compile procedure)
(compile-file procedure)
(compile-file-message thread-param)
(compile-imported-libraries thread-param)
(compile-interpret-simple thread-param)
(compile-library procedure)
(compile-library-handler thread-param)
(compile-port procedure)
(compile-profile thread-param)
(compile-program procedure)
(compile-program-handler thread-param)
(compile-script procedure)
(compile-time-value? procedure)
(compile-time-value-value procedure)
(compile-to-file procedure)
(compile-to-port procedure)
(compile-whole-library procedure)
(compile-whole-program procedure)
(complex? procedure)
(compress-format thread-param)
(compress-level thread-param)
(compute-composition procedure)
(compute-size procedure)
(concatenate-object-files procedure)
(cond syntax)
(condition procedure)
(condition? procedure)
(condition-accessor procedure)
(condition-broadcast procedure)
(condition-continuation procedure)
(condition-irritants procedure)
(condition-message procedure)
(condition-name procedure)
(condition-predicate procedure)
(condition-signal procedure)
(condition-wait procedure)
(condition-who procedure)
(conjugate procedure)
(cons procedure)
(cons* procedure)
(console-error-port thread-param)
(console-input-port global-param)
(console-output-port global-param)
(constructor syntax)
(continuation-condition? procedure)
(copy-environment procedure)
(copy-time procedure)
(cos procedure)
(cosh procedure)
(cost-center? procedure)
(cost-center-allocation-count procedure)
(cost-center-instruction-count procedure)
(cost-center-time procedure)
(cp0-effort-limit thread-param)
(cp0-outer-unroll-limit thread-param)
(cp0-score-limit thread-param)
(cpu-time procedure)
(create-exception-state procedure)
(critical-section syntax)
(csv7:record-field-accessible? procedure)
(csv7:record-field-accessor procedure)
(csv7:record-field-mutable? procedure)
(csv7:record-field-mutator procedure)
(csv7:record-type-descriptor procedure)
(csv7:record-type-field-decls procedure)
(csv7:record-type-field-names procedure)
(csv7:record-type-name procedure)
(csv7:record-type-symbol procedure)
(current-date procedure)
(current-directory global-param)
(current-error-port procedure)
(current-eval thread-param)
(current-exception-state thread-param)
(current-expand thread-param)
(current-input-port procedure)
(current-locate-source-object-source thread-param)
(current-make-source-object thread-param)
(current-memory-bytes procedure)
(current-output-port procedure)
(current-time procedure)
(current-transcoder thread-param)
(custom-port-buffer-size thread-param)
(date? procedure)
(date->time-utc procedure)
(date-and-time procedure)
(date-day procedure)
(date-dst? procedure)
(date-hour procedure)
(date-minute procedure)
(date-month procedure)
(date-nanosecond procedure)
(date-second procedure)
(date-week-day procedure)
(date-year procedure)
(date-year-day procedure)
(date-zone-name procedure)
(date-zone-offset procedure)
(datum syntax)
(datum->syntax procedure)
(datum->syntax-object procedure)
(debug procedure)
(debug-condition thread-param)
(debug-level thread-param)
(debug-on-exception global-param)
(decode-float procedure)
(default-exception-handler procedure)
(default-library-search-handler procedure)
(default-prompt-and-read procedure)
(default-record-equal-procedure thread-param)
(default-record-hash-procedure thread-param)
(define syntax)
(define-condition-type syntax)
(define-enumeration syntax)
(define-ftype syntax)
(define-property syntax)
(define-record syntax)
(define-record-type syntax)
(define-structure syntax)
(define-syntax syntax)
(define-top-level-syntax procedure)
(define-top-level-value procedure)
(define-values syntax)
(delay syntax)
(delete-directory procedure)
(delete-file procedure)
(denominator procedure)
(directory-list procedure)
(directory-separator procedure)
(directory-separator? procedure)
(disable-interrupts procedure)
(display procedure)
(display-condition procedure)
(display-statistics procedure)
(display-string procedure)
(div procedure)
(div0 procedure)
(div0-and-mod0 procedure)
(div-and-mod procedure)
(do syntax)
(drop-prefix syntax)
(dynamic-wind procedure)
(else syntax)
(enable-cross-library-optimization thread-param)
(enable-interrupts procedure)
(enable-object-counts global-param)
(endianness syntax)
(engine-block procedure)
(engine-return procedure)
(enumerate procedure)
(enum-set? procedure)
(enum-set=? procedure)
(enum-set->list procedure)
(enum-set-complement procedure)
(enum-set-constructor procedure)
(enum-set-difference procedure)
(enum-set-indexer procedure)
(enum-set-intersection procedure)
(enum-set-member? procedure)
(enum-set-projection procedure)
(enum-set-subset? procedure)
(enum-set-union procedure)
(enum-set-universe procedure)
(environment procedure)
(environment? procedure)
(environment-mutable? procedure)
(environment-symbols procedure)
(eof-object procedure)
(eof-object? procedure)
(eol-style syntax)
(ephemeron-cons procedure)
(ephemeron-pair? procedure)
(eq? procedure)
(eq-hashtable? procedure)
(eq-hashtable-cell procedure)
(eq-hashtable-contains? procedure)
(eq-hashtable-delete! procedure)
(eq-hashtable-ephemeron? procedure)
(eq-hashtable-ref procedure)
(eq-hashtable-set! procedure)
(eq-hashtable-update! procedure)
(eq-hashtable-weak? procedure)
(equal? procedure)
(equal-hash procedure)
(eqv? procedure)
(error procedure)
(error? procedure)
(errorf procedure)
(error-handling-mode syntax)
(eval procedure)
(eval-syntax-expanders-when thread-param)
(eval-when syntax)
(even? procedure)
(exact procedure)
(exact? procedure)
(exact->inexact procedure)
(exact-integer-sqrt procedure)
(except syntax)
(exclusive-cond syntax)
(exists procedure)
(exit procedure)
(exit-handler thread-param)
(exp procedure)
(expand procedure)
(expand/optimize procedure)
(expand/optimize-output thread-param)
(expand-output thread-param)
(export syntax)
(expression-editor module)
(expt procedure)
(expt-mod procedure)
(extend-syntax syntax)
(fasl-compressed thread-param)
(fasl-file procedure)
(fasl-read procedure)
(fasl-strip-options syntax)
(fasl-write procedure)
(fields syntax)
(file-access-time procedure)
(file-buffer-size thread-param)
(file-change-time procedure)
(file-directory? procedure)
(file-exists? procedure)
(file-length procedure)
(file-modification-time procedure)
(file-options syntax)
(file-port? procedure)
(file-position procedure)
(file-regular? procedure)
(file-symbolic-link? procedure)
(filter procedure)
(find procedure)
(finite? procedure)
(fixnum? procedure)
(fixnum->flonum procedure)
(fixnum-width procedure)
(fl- procedure)
(fl* procedure)
(fl/ procedure)
(fl+ procedure)
(fl< procedure)
(fl<? procedure)
(fl<= procedure)
(fl<=? procedure)
(fl= procedure)
(fl=? procedure)
(fl> procedure)
(fl>? procedure)
(fl>= procedure)
(fl>=? procedure)
(flabs procedure)
(flacos procedure)
(flasin procedure)
(flatan procedure)
(flceiling procedure)
(flcos procedure)
(fldenominator procedure)
(fldiv procedure)
(fldiv0 procedure)
(fldiv0-and-mod0 procedure)
(fldiv-and-mod procedure)
(fleven? procedure)
(flexp procedure)
(flexpt procedure)
(flfinite? procedure)
(flfloor procedure)
(flinfinite? procedure)
(flinteger? procedure)
(fllog procedure)
(fllp procedure)
(fl-make-rectangular procedure)
(flmax procedure)
(flmin procedure)
(flmod procedure)
(flmod0 procedure)
(flnan? procedure)
(flnegative? procedure)
(flnonnegative? procedure)
(flnonpositive? procedure)
(flnumerator procedure)
(flodd? procedure)
(flonum? procedure)
(flonum->fixnum procedure)
(floor procedure)
(flpositive? procedure)
(flround procedure)
(flsin procedure)
(flsqrt procedure)
(fltan procedure)
(fltruncate procedure)
(fluid-let syntax)
(fluid-let-syntax syntax)
(flush-output-port procedure)
(flzero? procedure)
(fold-left procedure)
(fold-right procedure)
(for-all procedure)
(force procedure)
(for-each procedure)
(foreign-address-name procedure)
(foreign-alloc procedure)
(foreign-callable syntax)
(foreign-callable-code-object procedure)
(foreign-callable-entry-point procedure)
(foreign-entry procedure)
(foreign-entry? procedure)
(foreign-free procedure)
(foreign-procedure syntax)
(foreign-ref procedure)
(foreign-set! procedure)
(foreign-sizeof procedure)
(fork-thread procedure)
(format procedure)
(format-condition? procedure)
(fprintf procedure)
(free-identifier=? procedure)
(fresh-line procedure)
(ftype-&ref syntax)
(ftype-guardian syntax)
(ftype-init-lock! syntax)
(ftype-lock! syntax)
(ftype-locked-decr! syntax)
(ftype-locked-incr! syntax)
(ftype-pointer? syntax)
(ftype-pointer=? syntax)
(ftype-pointer->sexpr procedure)
(ftype-pointer-address procedure)
(ftype-pointer-ftype procedure)
(ftype-pointer-null? syntax)
(ftype-ref syntax)
(ftype-set! syntax)
(ftype-sizeof syntax)
(ftype-spin-lock! syntax)
(ftype-unlock! syntax)
(fx- procedure)
(fx* procedure)
(fx*/carry procedure)
(fx/ procedure)
(fx-/carry procedure)
(fx+ procedure)
(fx+/carry procedure)
(fx< procedure)
(fx<? procedure)
(fx<= procedure)
(fx<=? procedure)
(fx= procedure)
(fx=? procedure)
(fx> procedure)
(fx>? procedure)
(fx>= procedure)
(fx>=? procedure)
(fx1- procedure)
(fx1+ procedure)
(fxabs procedure)
(fxand procedure)
(fxarithmetic-shift procedure)
(fxarithmetic-shift-left procedure)
(fxarithmetic-shift-right procedure)
(fxbit-count procedure)
(fxbit-field procedure)
(fxbit-set? procedure)
(fxcopy-bit procedure)
(fxcopy-bit-field procedure)
(fxdiv procedure)
(fxdiv0 procedure)
(fxdiv0-and-mod0 procedure)
(fxdiv-and-mod procedure)
(fxeven? procedure)
(fxfirst-bit-set procedure)
(fxif procedure)
(fxior procedure)
(fxlength procedure)
(fxlogand procedure)
(fxlogbit? procedure)
(fxlogbit0 procedure)
(fxlogbit1 procedure)
(fxlogior procedure)
(fxlognot procedure)
(fxlogor procedure)
(fxlogtest procedure)
(fxlogxor procedure)
(fxmax procedure)
(fxmin procedure)
(fxmod procedure)
(fxmod0 procedure)
(fxmodulo procedure)
(fxnegative? procedure)
(fxnonnegative? procedure)
(fxnonpositive? procedure)
(fxnot procedure)
(fxodd? procedure)
(fxpositive? procedure)
(fxquotient procedure)
(fxremainder procedure)
(fxreverse-bit-field procedure)
(fxrotate-bit-field procedure)
(fxsll procedure)
(fxsra procedure)
(fxsrl procedure)
(fxvector procedure)
(fxvector? procedure)
(fxvector->immutable-fxvector procedure)
(fxvector->list procedure)
(fxvector-copy procedure)
(fxvector-fill! procedure)
(fxvector-length procedure)
(fxvector-ref procedure)
(fxvector-set! procedure)
(fxxor procedure)
(fxzero? procedure)
(gcd procedure)
(generate-allocation-counts thread-param)
(generate-covin-files thread-param)
(generate-inspector-information thread-param)
(generate-instruction-counts thread-param)
(generate-interrupt-trap thread-param)
(generate-procedure-source-information thread-param)
(generate-profile-forms thread-param)
(generate-temporaries procedure)
(generate-wpo-files thread-param)
(gensym procedure)
(gensym? procedure)
(gensym->unique-string procedure)
(gensym-count thread-param)
(gensym-prefix thread-param)
(get-bytevector-all procedure)
(get-bytevector-n procedure)
(get-bytevector-n! procedure)
(get-bytevector-some procedure)
(get-bytevector-some! procedure)
(get-char procedure)
(get-datum procedure)
(get-datum/annotations procedure)
(getenv procedure)
(get-hash-table procedure)
(get-line procedure)
(get-mode procedure)
(get-output-string procedure)
(get-process-id procedure)
(getprop procedure)
(get-source-table! procedure)
(get-string-all procedure)
(get-string-n procedure)
(get-string-n! procedure)
(get-string-some procedure)
(get-string-some! procedure)
(get-thread-id procedure)
(get-u8 procedure)
(greatest-fixnum procedure)
(guard syntax)
(guardian? procedure)
(hashtable? procedure)
(hash-table? procedure)
(hashtable-cell procedure)
(hashtable-cells procedure)
(hashtable-clear! procedure)
(hashtable-contains? procedure)
(hashtable-copy procedure)
(hashtable-delete! procedure)
(hashtable-entries procedure)
(hashtable-ephemeron? procedure)
(hashtable-equivalence-function procedure)
(hash-table-for-each procedure)
(hashtable-hash-function procedure)
(hashtable-keys procedure)
(hash-table-map procedure)
(hashtable-mutable? procedure)
(hashtable-ref procedure)
(hashtable-set! procedure)
(hashtable-size procedure)
(hashtable-update! procedure)
(hashtable-values procedure)
(hashtable-weak? procedure)
(heap-reserve-ratio global-param)
(i/o-decoding-error? procedure)
(i/o-encoding-error? procedure)
(i/o-encoding-error-char procedure)
(i/o-error? procedure)
(i/o-error-filename procedure)
(i/o-error-port procedure)
(i/o-error-position procedure)
(i/o-file-already-exists-error? procedure)
(i/o-file-does-not-exist-error? procedure)
(i/o-file-is-read-only-error? procedure)
(i/o-filename-error? procedure)
(i/o-file-protection-error? procedure)
(i/o-invalid-position-error? procedure)
(i/o-port-error? procedure)
(i/o-read-error? procedure)
(i/o-write-error? procedure)
(iconv-codec procedure)
(identifier? procedure)
(identifier-syntax syntax)
(ieee module)
(ieee-environment procedure)
(if syntax)
(imag-part procedure)
(immutable syntax)
(immutable-box? procedure)
(immutable-bytevector? procedure)
(immutable-fxvector? procedure)
(immutable-string? procedure)
(immutable-vector? procedure)
(implementation-restriction-violation? procedure)
(implicit-exports syntax)
(import syntax)
(import-notify thread-param)
(import-only syntax)
(include syntax)
(indirect-export syntax)
(inexact procedure)
(inexact? procedure)
(inexact->exact procedure)
(infinite? procedure)
(initial-bytes-allocated procedure)
(input-port? procedure)
(input-port-ready? procedure)
(inspect procedure)
(inspect/object procedure)
(integer? procedure)
(integer->char procedure)
(integer-length procedure)
(integer-valued? procedure)
(interaction-environment thread-param)
(interactive? procedure)
(internal-defines-as-letrec* thread-param)
(interpret procedure)
(invoke-library procedure)
(iota procedure)
(irritants-condition? procedure)
(isqrt procedure)
(keyboard-interrupt-handler thread-param)
(lambda syntax)
(last-pair procedure)
(latin-1-codec procedure)
(lcm procedure)
(least-fixnum procedure)
(length procedure)
(let syntax)
(let* syntax)
(let*-values syntax)
(letrec syntax)
(letrec* syntax)
(letrec-syntax syntax)
(let-syntax syntax)
(let-values syntax)
(lexical-violation? procedure)
(library syntax)
(library-directories thread-param)
(library-exports procedure)
(library-extensions thread-param)
(library-list procedure)
(library-object-filename procedure)
(library-requirements procedure)
(library-requirements-options syntax)
(library-search-handler thread-param)
(library-version procedure)
(list procedure)
(list* procedure)
(list? procedure)
(list->fxvector procedure)
(list->string procedure)
(list->vector procedure)
(list-copy procedure)
(list-head procedure)
(list-ref procedure)
(list-sort procedure)
(list-tail procedure)
(literal-identifier=? procedure)
(load procedure)
(load-compiled-from-port procedure)
(load-library procedure)
(load-program procedure)
(load-shared-object procedure)
(locate-source procedure)
(locate-source-object-source procedure)
(locked-object? procedure)
(lock-object procedure)
(log procedure)
(logand procedure)
(logbit? procedure)
(logbit0 procedure)
(logbit1 procedure)
(logior procedure)
(lognot procedure)
(logor procedure)
(logtest procedure)
(logxor procedure)
(lookahead-char procedure)
(lookahead-u8 procedure)
(machine-type procedure)
(magnitude procedure)
(magnitude-squared procedure)
(make-annotation procedure)
(make-assertion-violation procedure)
(make-boot-file procedure)
(make-boot-header procedure)
(make-bytevector procedure)
(make-compile-time-value procedure)
(make-condition procedure)
(make-continuation-condition procedure)
(make-cost-center procedure)
(make-custom-binary-input/output-port procedure)
(make-custom-binary-input-port procedure)
(make-custom-binary-output-port procedure)
(make-custom-textual-input/output-port procedure)
(make-custom-textual-input-port procedure)
(make-custom-textual-output-port procedure)
(make-date procedure)
(make-engine procedure)
(make-enumeration procedure)
(make-ephemeron-eq-hashtable procedure)
(make-ephemeron-eqv-hashtable procedure)
(make-eq-hashtable procedure)
(make-eqv-hashtable procedure)
(make-error procedure)
(make-format-condition procedure)
(make-ftype-pointer syntax)
(make-fxvector procedure)
(make-guardian procedure)
(make-hashtable procedure)
(make-hash-table procedure)
(make-i/o-decoding-error procedure)
(make-i/o-encoding-error procedure)
(make-i/o-error procedure)
(make-i/o-file-already-exists-error procedure)
(make-i/o-file-does-not-exist-error procedure)
(make-i/o-file-is-read-only-error procedure)
(make-i/o-filename-error procedure)
(make-i/o-file-protection-error procedure)
(make-i/o-invalid-position-error procedure)
(make-i/o-port-error procedure)
(make-i/o-read-error procedure)
(make-i/o-write-error procedure)
(make-implementation-restriction-violation procedure)
(make-input/output-port procedure)
(make-input-port procedure)
(make-irritants-condition procedure)
(make-lexical-violation procedure)
(make-list procedure)
(make-message-condition procedure)
(make-mutex procedure)
(make-no-infinities-violation procedure)
(make-no-nans-violation procedure)
(make-non-continuable-violation procedure)
(make-object-finder procedure)
(make-output-port procedure)
(make-parameter procedure)
(make-polar procedure)
(make-record-constructor-descriptor procedure)
(make-record-type procedure)
(make-record-type-descriptor procedure)
(make-rectangular procedure)
(make-serious-condition procedure)
(make-source-condition procedure)
(make-source-file-descriptor procedure)
(make-source-object procedure)
(make-source-table procedure)
(make-sstats procedure)
(make-string procedure)
(make-syntax-violation procedure)
(make-thread-parameter procedure)
(make-time procedure)
(make-transcoder procedure)
(make-undefined-violation procedure)
(make-variable-transformer procedure)
(make-vector procedure)
(make-violation procedure)
(make-warning procedure)
(make-weak-eq-hashtable procedure)
(make-weak-eqv-hashtable procedure)
(make-who-condition procedure)
(map procedure)
(mark-port-closed! procedure)
(max procedure)
(maximum-memory-bytes procedure)
(maybe-compile-file procedure)
(maybe-compile-library procedure)
(maybe-compile-program procedure)
(member procedure)
(memp procedure)
(memq procedure)
(memv procedure)
(merge procedure)
(merge! procedure)
(message-condition? procedure)
(meta syntax)
(meta-cond syntax)
(min procedure)
(mkdir procedure)
(mod procedure)
(mod0 procedure)
(module syntax)
(modulo procedure)
(most-negative-fixnum procedure)
(most-positive-fixnum procedure)
(mutable syntax)
(mutable-box? procedure)
(mutable-bytevector? procedure)
(mutable-fxvector? procedure)
(mutable-string? procedure)
(mutable-vector? procedure)
(mutex? procedure)
(mutex-acquire procedure)
(mutex-name procedure)
(mutex-release procedure)
(nan? procedure)
(native-endianness procedure)
(native-eol-style procedure)
(native-transcoder procedure)
(negative? procedure)
(new-cafe procedure)
(newline procedure)
(no-infinities-violation? procedure)
(no-nans-violation? procedure)
(non-continuable-violation? procedure)
(nongenerative syntax)
(nonnegative? procedure)
(nonpositive? procedure)
(not procedure)
(null? procedure)
(null-environment procedure)
(number? procedure)
(number->string procedure)
(numerator procedure)
(object-counts procedure)
(oblist procedure)
(odd? procedure)
(only syntax)
(opaque syntax)
(open-bytevector-input-port procedure)
(open-bytevector-output-port procedure)
(open-fd-input/output-port procedure)
(open-fd-input-port procedure)
(open-fd-output-port procedure)
(open-file-input/output-port procedure)
(open-file-input-port procedure)
(open-file-output-port procedure)
(open-input-file procedure)
(open-input-output-file procedure)
(open-input-string procedure)
(open-output-file procedure)
(open-output-string procedure)
(open-process-ports procedure)
(open-source-file procedure)
(open-string-input-port procedure)
(open-string-output-port procedure)
(optimize-level thread-param)
(or syntax)
(ormap procedure)
(output-port? procedure)
(output-port-buffer-mode procedure)
(pair? procedure)
(parameterize syntax)
(parent syntax)
(parent-rtd syntax)
(pariah syntax)
(partition procedure)
(path-absolute? procedure)
(path-extension procedure)
(path-first procedure)
(path-last procedure)
(path-parent procedure)
(path-rest procedure)
(path-root procedure)
(peek-char procedure)
(petite? procedure)
(port? procedure)
(port-bol? procedure)
(port-closed? procedure)
(port-eof? procedure)
(port-file-compressed! procedure)
(port-file-descriptor procedure)
(port-handler procedure)
(port-has-port-length? procedure)
(port-has-port-nonblocking?? procedure)
(port-has-port-position? procedure)
(port-has-set-port-length!? procedure)
(port-has-set-port-nonblocking!? procedure)
(port-has-set-port-position!? procedure)
(port-input-buffer procedure)
(port-input-count procedure)
(port-input-empty? procedure)
(port-input-index procedure)
(port-input-size procedure)
(port-length procedure)
(port-name procedure)
(port-nonblocking? procedure)
(port-output-buffer procedure)
(port-output-count procedure)
(port-output-full? procedure)
(port-output-index procedure)
(port-output-size procedure)
(port-position procedure)
(port-transcoder procedure)
(positive? procedure)
(predicate syntax)
(prefix syntax)
(pretty-file procedure)
(pretty-format procedure)
(pretty-initial-indent thread-param)
(pretty-line-length thread-param)
(pretty-maximum-lines thread-param)
(pretty-one-line-limit thread-param)
(pretty-print procedure)
(pretty-standard-indent thread-param)
(print-brackets thread-param)
(print-char-name thread-param)
(print-extended-identifiers thread-param)
(printf procedure)
(print-gensym thread-param)
(print-graph thread-param)
(print-length thread-param)
(print-level thread-param)
(print-precision thread-param)
(print-radix thread-param)
(print-record thread-param)
(print-unicode thread-param)
(print-vector-length thread-param)
(procedure? procedure)
(procedure-arity-mask procedure)
(process procedure)
(profile syntax)
(profile-clear procedure)
(profile-clear-database procedure)
(profile-dump procedure)
(profile-dump-data procedure)
(profile-dump-html procedure)
(profile-dump-list procedure)
(profile-line-number-color thread-param)
(profile-load-data procedure)
(profile-palette thread-param)
(profile-query-weight procedure)
(profile-release-counters procedure)
(property-list procedure)
(protocol syntax)
(put-bytevector procedure)
(put-bytevector-some procedure)
(put-char procedure)
(put-datum procedure)
(putenv procedure)
(put-hash-table! procedure)
(putprop procedure)
(put-source-table procedure)
(put-string procedure)
(put-string-some procedure)
(put-u8 procedure)
(quasiquote syntax)
(quasisyntax syntax)
(quote syntax)
(quotient procedure)
(r5rs module)
(r5rs-syntax module)
(r6rs:< procedure)
(r6rs:<= procedure)
(r6rs:= procedure)
(r6rs:> procedure)
(r6rs:>= procedure)
(r6rs:call-with-input-file procedure)
(r6rs:call-with-output-file procedure)
(r6rs:case procedure)
(r6rs:char<? procedure)
(r6rs:char<=? procedure)
(r6rs:char=? procedure)
(r6rs:char>? procedure)
(r6rs:char>=? procedure)
(r6rs:char-ci<? procedure)
(r6rs:char-ci<=? procedure)
(r6rs:char-ci=? procedure)
(r6rs:char-ci>? procedure)
(r6rs:char-ci>=? procedure)
(r6rs:command-line procedure)
(r6rs:current-error-port procedure)
(r6rs:current-input-port procedure)
(r6rs:current-output-port procedure)
(r6rs:delete-file procedure)
(r6rs:dynamic-wind procedure)
(r6rs:eval procedure)
(r6rs:exit procedure)
(r6rs:file-exists? procedure)
(r6rs:flush-output-port procedure)
(r6rs:fx- procedure)
(r6rs:fx* procedure)
(r6rs:fx+ procedure)
(r6rs:hashtable-entries procedure)
(r6rs:hashtable-keys procedure)
(r6rs:number->string procedure)
(r6rs:open-input-file procedure)
(r6rs:open-output-file procedure)
(r6rs:record? procedure)
(r6rs:record-constructor procedure)
(r6rs:standard-error-port procedure)
(r6rs:standard-input-port procedure)
(r6rs:standard-output-port procedure)
(r6rs:string<? procedure)
(r6rs:string<=? procedure)
(r6rs:string=? procedure)
(r6rs:string>? procedure)
(r6rs:string>=? procedure)
(r6rs:string->number procedure)
(r6rs:string-ci<? procedure)
(r6rs:string-ci<=? procedure)
(r6rs:string-ci=? procedure)
(r6rs:string-ci>? procedure)
(r6rs:string-ci>=? procedure)
(r6rs:syntax-rules procedure)
(r6rs:utf-16-codec procedure)
(r6rs:with-input-from-file procedure)
(r6rs:with-output-to-file procedure)
(raise procedure)
(raise-continuable procedure)
(random procedure)
(random-seed thread-param)
(rational? procedure)
(rationalize procedure)
(rational-valued? procedure)
(ratnum? procedure)
(read procedure)
(read-char procedure)
(read-token procedure)
(real? procedure)
(real->flonum procedure)
(real-part procedure)
(real-time procedure)
(real-valued? procedure)
(rec syntax)
(record? procedure)
(record-accessor procedure)
(record-case syntax)
(record-constructor procedure)
(record-constructor-descriptor syntax)
(record-constructor-descriptor? procedure)
(record-equal-procedure procedure)
(record-field-mutable? procedure)
(record-hash-procedure procedure)
(record-mutator procedure)
(record-predicate procedure)
(record-reader procedure)
(record-rtd procedure)
(record-type-descriptor procedure)
(record-type-descriptor? procedure)
(record-type-equal-procedure procedure)
(record-type-field-names procedure)
(record-type-generative? procedure)
(record-type-hash-procedure procedure)
(record-type-name procedure)
(record-type-opaque? procedure)
(record-type-parent procedure)
(record-type-sealed? procedure)
(record-type-uid procedure)
(record-writer procedure)
(register-signal-handler procedure)
(release-minimum-generation global-param)
(remainder procedure)
(remove procedure)
(remove! procedure)
(remove-foreign-entry procedure)
(remove-hash-table! procedure)
(remp procedure)
(remprop procedure)
(remq procedure)
(remq! procedure)
(remv procedure)
(remv! procedure)
(rename syntax)
(rename-file procedure)
(require-nongenerative-clause thread-param)
(reset procedure)
(reset-cost-center! procedure)
(reset-handler thread-param)
(reset-maximum-memory-bytes! procedure)
(reverse procedure)
(reverse! procedure)
(revisit procedure)
(revisit-compiled-from-port procedure)
(round procedure)
(run-cp0 thread-param)
(s8-list->bytevector procedure)
(sc-expand procedure)
(scheme module)
(scheme-environment procedure)
(scheme-program global-param)
(scheme-report-environment procedure)
(scheme-script global-param)
(scheme-start global-param)
(scheme-version procedure)
(scheme-version-number procedure)
(sealed syntax)
(self-evaluating-vectors thread-param)
(serious-condition? procedure)
(set! syntax)
(set-binary-port-input-buffer! procedure)
(set-binary-port-input-index! procedure)
(set-binary-port-input-size! procedure)
(set-binary-port-output-buffer! procedure)
(set-binary-port-output-index! procedure)
(set-binary-port-output-size! procedure)
(set-box! procedure)
(set-car! procedure)
(set-cdr! procedure)
(set-port-bol! procedure)
(set-port-eof! procedure)
(set-port-input-buffer! procedure)
(set-port-input-index! procedure)
(set-port-input-size! procedure)
(set-port-length! procedure)
(set-port-name! procedure)
(set-port-nonblocking! procedure)
(set-port-output-buffer! procedure)
(set-port-output-index! procedure)
(set-port-output-size! procedure)
(set-port-position! procedure)
(set-sstats-bytes! procedure)
(set-sstats-cpu! procedure)
(set-sstats-gc-bytes! procedure)
(set-sstats-gc-count! procedure)
(set-sstats-gc-cpu! procedure)
(set-sstats-gc-real! procedure)
(set-sstats-real! procedure)
(set-textual-port-input-buffer! procedure)
(set-textual-port-input-index! procedure)
(set-textual-port-input-size! procedure)
(set-textual-port-output-buffer! procedure)
(set-textual-port-output-index! procedure)
(set-textual-port-output-size! procedure)
(set-time-nanosecond! procedure)
(set-timer procedure)
(set-time-second! procedure)
(set-time-type! procedure)
(set-top-level-value! procedure)
(set-virtual-register! procedure)
(simple-conditions procedure)
(sin procedure)
(sinh procedure)
(sint-list->bytevector procedure)
(sleep procedure)
(sort procedure)
(sort! procedure)
(source-condition? procedure)
(source-condition-form procedure)
(source-directories global-param)
(source-file-descriptor procedure)
(source-file-descriptor? procedure)
(source-file-descriptor-checksum procedure)
(source-file-descriptor-path procedure)
(source-object? procedure)
(source-object-bfp procedure)
(source-object-column procedure)
(source-object-efp procedure)
(source-object-line procedure)
(source-object-sfd procedure)
(source-table? procedure)
(source-table-cell procedure)
(source-table-contains? procedure)
(source-table-delete! procedure)
(source-table-dump procedure)
(source-table-ref procedure)
(source-table-set! procedure)
(source-table-size procedure)
(sqrt procedure)
(sstats? procedure)
(sstats-bytes procedure)
(sstats-cpu procedure)
(sstats-difference procedure)
(sstats-gc-bytes procedure)
(sstats-gc-count procedure)
(sstats-gc-cpu procedure)
(sstats-gc-real procedure)
(sstats-print procedure)
(sstats-real procedure)
(standard-error-port procedure)
(standard-input-port procedure)
(standard-output-port procedure)
(statistics procedure)
(string procedure)
(string? procedure)
(string<? procedure)
(string<=? procedure)
(string=? procedure)
(string>? procedure)
(string>=? procedure)
(string->bytevector procedure)
(string->immutable-string procedure)
(string->list procedure)
(string->number procedure)
(string->symbol procedure)
(string->utf16 procedure)
(string->utf32 procedure)
(string->utf8 procedure)
(string-append procedure)
(string-ci<? procedure)
(string-ci<=? procedure)
(string-ci=? procedure)
(string-ci>? procedure)
(string-ci>=? procedure)
(string-ci-hash procedure)
(string-copy procedure)
(string-copy! procedure)
(string-downcase procedure)
(string-fill! procedure)
(string-foldcase procedure)
(string-for-each procedure)
(string-hash procedure)
(string-length procedure)
(string-normalize-nfc procedure)
(string-normalize-nfd procedure)
(string-normalize-nfkc procedure)
(string-normalize-nfkd procedure)
(string-ref procedure)
(string-set! procedure)
(string-titlecase procedure)
(string-truncate! procedure)
(string-upcase procedure)
(strip-fasl-file procedure)
(sub1 procedure)
(subset-mode thread-param)
(subst procedure)
(subst! procedure)
(substq procedure)
(substq! procedure)
(substring procedure)
(substring-fill! procedure)
(substv procedure)
(substv! procedure)
(subtract-duration procedure)
(subtract-duration! procedure)
(suppress-greeting global-param)
(symbol? procedure)
(symbol=? procedure)
(symbol->string procedure)
(symbol-hash procedure)
(symbol-hashtable? procedure)
(symbol-hashtable-cell procedure)
(symbol-hashtable-contains? procedure)
(symbol-hashtable-delete! procedure)
(symbol-hashtable-ref procedure)
(symbol-hashtable-set! procedure)
(symbol-hashtable-update! procedure)
(syntax syntax)
(syntax->annotation procedure)
(syntax->datum procedure)
(syntax->list procedure)
(syntax->vector procedure)
(syntax-case syntax)
(syntax-error procedure)
(syntax-object->datum procedure)
(syntax-rules syntax)
(syntax-violation procedure)
(syntax-violation? procedure)
(syntax-violation-form procedure)
(syntax-violation-subform procedure)
(system procedure)
(tan procedure)
(tanh procedure)
(textual-port? procedure)
(textual-port-input-buffer procedure)
(textual-port-input-count procedure)
(textual-port-input-index procedure)
(textual-port-input-size procedure)
(textual-port-output-buffer procedure)
(textual-port-output-count procedure)
(textual-port-output-index procedure)
(textual-port-output-size procedure)
(thread? procedure)
(thread-condition? procedure)
(threaded? procedure)
(time syntax)
(time? procedure)
(time<? procedure)
(time<=? procedure)
(time=? procedure)
(time>? procedure)
(time>=? procedure)
(time-difference procedure)
(time-difference! procedure)
(time-nanosecond procedure)
(timer-interrupt-handler thread-param)
(time-second procedure)
(time-type procedure)
(time-utc->date procedure)
(top-level-bound? procedure)
(top-level-mutable? procedure)
(top-level-program syntax)
(top-level-syntax procedure)
(top-level-syntax? procedure)
(top-level-value procedure)
(trace syntax)
(trace-case-lambda syntax)
(trace-define syntax)
(trace-define-syntax syntax)
(trace-do syntax)
(trace-lambda syntax)
(trace-let syntax)
(trace-output-port thread-param)
(trace-print thread-param)
(transcoded-port procedure)
(transcoder? procedure)
(transcoder-codec procedure)
(transcoder-eol-style procedure)
(transcoder-error-handling-mode procedure)
(transcript-cafe procedure)
(transcript-off procedure)
(transcript-on procedure)
(truncate procedure)
(truncate-file procedure)
(truncate-port procedure)
(type-descriptor syntax)
(u8-list->bytevector procedure)
(uint-list->bytevector procedure)
(unbox procedure)
(undefined-variable-warnings thread-param)
(undefined-violation? procedure)
(unget-char procedure)
(unget-u8 procedure)
(unless syntax)
(unlock-object procedure)
(unquote syntax)
(unquote-splicing syntax)
(unread-char procedure)
(unregister-guardian procedure)
(unsyntax syntax)
(unsyntax-splicing syntax)
(untrace syntax)
(utf16->string procedure)
(utf-16be-codec procedure)
(utf-16-codec procedure)
(utf-16le-codec procedure)
(utf32->string procedure)
(utf8->string procedure)
(utf-8-codec procedure)
(values procedure)
(vector procedure)
(vector? procedure)
(vector->immutable-vector procedure)
(vector->list procedure)
(vector-cas! procedure)
(vector-copy procedure)
(vector-fill! procedure)
(vector-for-each procedure)
(vector-length procedure)
(vector-map procedure)
(vector-ref procedure)
(vector-set! procedure)
(vector-set-fixnum! procedure)
(vector-sort procedure)
(vector-sort! procedure)
(verify-loadability procedure)
(violation? procedure)
(virtual-register procedure)
(virtual-register-count procedure)
(visit procedure)
(visit-compiled-from-port procedure)
(void procedure)
(waiter-prompt-and-read thread-param)
(waiter-prompt-string thread-param)
(waiter-write thread-param)
(warning procedure)
(warning? procedure)
(warningf procedure)
(weak-cons procedure)
(weak-pair? procedure)
(when syntax)
(who-condition? procedure)
(with-cost-center procedure)
(with-exception-handler procedure)
(with-implicit syntax)
(with-input-from-file procedure)
(with-input-from-string procedure)
(with-interrupts-disabled syntax)
(with-mutex syntax)
(with-output-to-file procedure)
(with-output-to-string procedure)
(with-profile-tracker procedure)
(with-source-path procedure)
(with-syntax syntax)
(write procedure)
(write-char procedure)
(zero? procedure))))

(define chezscheme (private-process '(chezscheme) '(
(- procedure)
($primitive syntax)
($system module)
(&assertion syntax)
(&condition syntax)
(&continuation syntax)
(&error syntax)
(&format syntax)
(&i/o syntax)
(&i/o-decoding syntax)
(&i/o-encoding syntax)
(&i/o-file-already-exists syntax)
(&i/o-file-does-not-exist syntax)
(&i/o-file-is-read-only syntax)
(&i/o-filename syntax)
(&i/o-file-protection syntax)
(&i/o-invalid-position syntax)
(&i/o-port syntax)
(&i/o-read syntax)
(&i/o-write syntax)
(&implementation-restriction syntax)
(&irritants syntax)
(&lexical syntax)
(&message syntax)
(&no-infinities syntax)
(&no-nans syntax)
(&non-continuable syntax)
(&serious syntax)
(&source syntax)
(&syntax syntax)
(&undefined syntax)
(&violation syntax)
(&warning syntax)
(&who syntax)
(* procedure)
(... syntax)
(/ procedure)
(_ syntax)
(+ procedure)
(< procedure)
(<= procedure)
(= procedure)
(=> syntax)
(> procedure)
(>= procedure)
; (1+ procedure)
(abort procedure-skipped)
(abort-handler thread-param)
(abs procedure)
(acos procedure)
(acosh procedure)
(add1 procedure)
(add-duration procedure)
(add-duration! procedure)
(add-prefix syntax)
(alias syntax)
(and syntax)
(andmap procedure)
(angle procedure)
(annotation? procedure)
(annotation-expression procedure)
(annotation-options procedure)
(annotation-option-set syntax)
(annotation-source procedure)
(annotation-stripped procedure)
(append procedure)
(append! procedure)
(apply procedure)
(apropos procedure)
(apropos-list procedure)
(ash procedure)
(asin procedure)
(asinh procedure)
(assert syntax)
(assertion-violation procedure)
(assertion-violation? procedure)
(assertion-violationf procedure)
(assoc procedure)
(assp procedure)
(assq procedure)
(assv procedure)
(atan procedure)
(atanh procedure)
(atom? procedure)
(base-exception-handler thread-param)
(begin syntax)
(bignum? procedure)
(binary-port? procedure)
(binary-port-input-buffer procedure)
(binary-port-input-count procedure)
(binary-port-input-index procedure)
(binary-port-input-size procedure)
(binary-port-output-buffer procedure)
(binary-port-output-count procedure)
(binary-port-output-index procedure)
(binary-port-output-size procedure)
(bitwise-and procedure)
(bitwise-arithmetic-shift procedure)
(bitwise-arithmetic-shift-left procedure)
(bitwise-arithmetic-shift-right procedure)
(bitwise-bit-count procedure)
(bitwise-bit-field procedure)
(bitwise-bit-set? procedure)
(bitwise-copy-bit procedure)
(bitwise-copy-bit-field procedure)
(bitwise-first-bit-set procedure)
(bitwise-if procedure)
(bitwise-ior procedure)
(bitwise-length procedure)
(bitwise-not procedure)
(bitwise-reverse-bit-field procedure)
(bitwise-rotate-bit-field procedure)
(bitwise-xor procedure)
(block-read procedure)
(block-write procedure)
(boolean? procedure)
(boolean=? procedure)
(bound-identifier=? procedure)
(box procedure)
(box? procedure)
(box-cas! procedure)
(box-immutable procedure)
(break procedure)
(break-handler thread-param)
(buffer-mode syntax)
(buffer-mode? syntax)
(bwp-object? procedure)
(bytes-allocated procedure)
(bytes-deallocated procedure)
(bytevector procedure)
(bytevector? procedure)
(bytevector=? procedure)
(bytevector->immutable-bytevector procedure)
(bytevector->s8-list procedure)
(bytevector->sint-list procedure)
(bytevector->string procedure)
(bytevector->u8-list procedure)
(bytevector->uint-list procedure)
(bytevector-compress procedure)
(bytevector-copy procedure)
(bytevector-copy! procedure)
(bytevector-fill! procedure)
(bytevector-ieee-double-native-ref procedure)
(bytevector-ieee-double-native-set! procedure)
(bytevector-ieee-double-ref procedure)
(bytevector-ieee-double-set! procedure)
(bytevector-ieee-single-native-ref procedure)
(bytevector-ieee-single-native-set! procedure)
(bytevector-ieee-single-ref procedure)
(bytevector-ieee-single-set! procedure)
(bytevector-length procedure)
(bytevector-s16-native-ref procedure)
(bytevector-s16-native-set! procedure)
(bytevector-s16-ref procedure)
(bytevector-s16-set! procedure)
(bytevector-s24-ref procedure)
(bytevector-s24-set! procedure)
(bytevector-s32-native-ref procedure)
(bytevector-s32-native-set! procedure)
(bytevector-s32-ref procedure)
(bytevector-s32-set! procedure)
(bytevector-s40-ref procedure)
(bytevector-s40-set! procedure)
(bytevector-s48-ref procedure)
(bytevector-s48-set! procedure)
(bytevector-s56-ref procedure)
(bytevector-s56-set! procedure)
(bytevector-s64-native-ref procedure)
(bytevector-s64-native-set! procedure)
(bytevector-s64-ref procedure)
(bytevector-s64-set! procedure)
(bytevector-s8-ref procedure)
(bytevector-s8-set! procedure)
(bytevector-sint-ref procedure)
(bytevector-sint-set! procedure)
(bytevector-truncate! procedure)
(bytevector-u16-native-ref procedure)
(bytevector-u16-native-set! procedure)
(bytevector-u16-ref procedure)
(bytevector-u16-set! procedure)
(bytevector-u24-ref procedure)
(bytevector-u24-set! procedure)
(bytevector-u32-native-ref procedure)
(bytevector-u32-native-set! procedure)
(bytevector-u32-ref procedure)
(bytevector-u32-set! procedure)
(bytevector-u40-ref procedure)
(bytevector-u40-set! procedure)
(bytevector-u48-ref procedure)
(bytevector-u48-set! procedure)
(bytevector-u56-ref procedure)
(bytevector-u56-set! procedure)
(bytevector-u64-native-ref procedure)
(bytevector-u64-native-set! procedure)
(bytevector-u64-ref procedure)
(bytevector-u64-set! procedure)
(bytevector-u8-ref procedure)
(bytevector-u8-set! procedure)
(bytevector-uint-ref procedure)
(bytevector-uint-set! procedure)
(bytevector-uncompress procedure)
(caaaar procedure)
(caaadr procedure)
(caaar procedure)
(caadar procedure)
(caaddr procedure)
(caadr procedure)
(caar procedure)
(cadaar procedure)
(cadadr procedure)
(cadar procedure)
(caddar procedure)
(cadddr procedure)
(caddr procedure)
(cadr procedure)
(call/1cc procedure)
(call/cc procedure)
(call-with-bytevector-output-port procedure)
(call-with-current-continuation procedure)
(call-with-input-file procedure)
(call-with-output-file procedure)
(call-with-port procedure)
(call-with-string-output-port procedure)
(call-with-values procedure)
(car procedure)
(case syntax)
(case-lambda syntax)
(case-sensitive thread-param)
(cd global-param)
(cdaaar procedure)
(cdaadr procedure)
(cdaar procedure)
(cdadar procedure)
(cdaddr procedure)
(cdadr procedure)
(cdar procedure)
(cddaar procedure)
(cddadr procedure)
(cddar procedure)
(cdddar procedure)
(cddddr procedure)
(cdddr procedure)
(cddr procedure)
(cdr procedure)
(ceiling procedure)
(cfl- procedure)
(cfl* procedure)
(cfl/ procedure)
(cfl+ procedure)
(cfl= procedure)
(cfl-conjugate procedure)
(cfl-imag-part procedure)
(cfl-magnitude-squared procedure)
(cflonum? procedure)
(cfl-real-part procedure)
(char- procedure)
(char? procedure)
(char<? procedure)
(char<=? procedure)
(char=? procedure)
(char>? procedure)
(char>=? procedure)
(char->integer procedure)
(char-alphabetic? procedure)
(char-ci<? procedure)
(char-ci<=? procedure)
(char-ci=? procedure)
(char-ci>? procedure)
(char-ci>=? procedure)
(char-downcase procedure)
(char-foldcase procedure)
(char-general-category procedure)
(char-lower-case? procedure)
(char-name procedure)
(char-numeric? procedure)
(char-ready? procedure)
(char-titlecase procedure)
(char-title-case? procedure)
(char-upcase procedure)
(char-upper-case? procedure)
(char-whitespace? procedure)
(chmod procedure)
(clear-input-port procedure)
(clear-output-port procedure)
(close-input-port procedure)
(close-output-port procedure)
(close-port procedure)
(collect procedure)
(collect-generation-radix global-param)
(collections procedure)
(collect-maximum-generation global-param)
(collect-notify global-param)
(collect-rendezvous procedure)
(collect-request-handler global-param)
(collect-trip-bytes global-param)
(command-line global-param)
(command-line-arguments global-param)
(commonization-level thread-param)
(compile procedure)
(compile-file procedure)
(compile-file-message thread-param)
(compile-imported-libraries thread-param)
(compile-interpret-simple thread-param)
(compile-library procedure)
(compile-library-handler thread-param)
(compile-port procedure)
(compile-profile thread-param)
(compile-program procedure)
(compile-program-handler thread-param)
(compile-script procedure)
(compile-time-value? procedure)
(compile-time-value-value procedure)
(compile-to-file procedure)
(compile-to-port procedure)
(compile-whole-library procedure)
(compile-whole-program procedure)
(complex? procedure)
(compress-format thread-param)
(compress-level thread-param)
(compute-composition procedure)
(compute-size procedure)
(concatenate-object-files procedure)
(cond syntax)
(condition procedure)
(condition? procedure)
(condition-accessor procedure)
(condition-broadcast procedure)
(condition-continuation procedure)
(condition-irritants procedure)
(condition-message procedure)
(condition-name procedure)
(condition-predicate procedure)
(condition-signal procedure)
(condition-wait procedure)
(condition-who procedure)
(conjugate procedure)
(cons procedure)
(cons* procedure)
(console-error-port thread-param)
(console-input-port global-param)
(console-output-port global-param)
(constructor syntax)
(continuation-condition? procedure)
(copy-environment procedure)
(copy-time procedure)
(cos procedure)
(cosh procedure)
(cost-center? procedure)
(cost-center-allocation-count procedure)
(cost-center-instruction-count procedure)
(cost-center-time procedure)
(cp0-effort-limit thread-param)
(cp0-outer-unroll-limit thread-param)
(cp0-score-limit thread-param)
(cpu-time procedure)
(create-exception-state procedure)
(critical-section syntax)
(csv7:record-field-accessible? procedure)
(csv7:record-field-accessor procedure)
(csv7:record-field-mutable? procedure)
(csv7:record-field-mutator procedure)
(csv7:record-type-descriptor procedure)
(csv7:record-type-field-decls procedure)
(csv7:record-type-field-names procedure)
(csv7:record-type-name procedure)
(csv7:record-type-symbol procedure)
(current-date procedure)
(current-directory global-param)
(current-error-port procedure)
(current-eval thread-param)
(current-exception-state thread-param)
(current-expand thread-param)
(current-input-port procedure)
(current-locate-source-object-source thread-param)
(current-make-source-object thread-param)
(current-memory-bytes procedure)
(current-output-port procedure)
(current-time procedure)
(current-transcoder thread-param)
(custom-port-buffer-size thread-param)
(date? procedure)
(date->time-utc procedure)
(date-and-time procedure)
(date-day procedure)
(date-dst? procedure)
(date-hour procedure)
(date-minute procedure)
(date-month procedure)
(date-nanosecond procedure)
(date-second procedure)
(date-week-day procedure)
(date-year procedure)
(date-year-day procedure)
(date-zone-name procedure)
(date-zone-offset procedure)
(datum syntax)
(datum->syntax procedure)
(datum->syntax-object procedure)
(debug procedure)
(debug-condition thread-param)
(debug-level thread-param)
(debug-on-exception global-param)
(decode-float procedure)
(default-exception-handler procedure)
(default-library-search-handler procedure)
(default-prompt-and-read procedure)
(default-record-equal-procedure thread-param)
(default-record-hash-procedure thread-param)
(define syntax)
(define-condition-type syntax)
(define-enumeration syntax)
(define-ftype syntax)
(define-property syntax)
(define-record syntax)
(define-record-type syntax)
(define-structure syntax)
(define-syntax syntax)
(define-top-level-syntax procedure)
(define-top-level-value procedure)
(define-values syntax)
(delay syntax)
(delete-directory procedure)
(delete-file procedure)
(denominator procedure)
(directory-list procedure)
(directory-separator procedure)
(directory-separator? procedure)
(disable-interrupts procedure)
(display procedure)
(display-condition procedure)
(display-statistics procedure)
(display-string procedure)
(div procedure)
(div0 procedure)
(div0-and-mod0 procedure)
(div-and-mod procedure)
(do syntax)
(drop-prefix syntax)
(dynamic-wind procedure)
(else syntax)
(enable-cross-library-optimization thread-param)
(enable-interrupts procedure)
(enable-object-counts global-param)
(endianness syntax)
(engine-block procedure)
(engine-return procedure)
(enumerate procedure)
(enum-set? procedure)
(enum-set=? procedure)
(enum-set->list procedure)
(enum-set-complement procedure)
(enum-set-constructor procedure)
(enum-set-difference procedure)
(enum-set-indexer procedure)
(enum-set-intersection procedure)
(enum-set-member? procedure)
(enum-set-projection procedure)
(enum-set-subset? procedure)
(enum-set-union procedure)
(enum-set-universe procedure)
(environment procedure)
(environment? procedure)
(environment-mutable? procedure)
(environment-symbols procedure)
(eof-object procedure)
(eof-object? procedure)
(eol-style syntax)
(ephemeron-cons procedure)
(ephemeron-pair? procedure)
(eq? procedure)
(eq-hashtable? procedure)
(eq-hashtable-cell procedure)
(eq-hashtable-contains? procedure)
(eq-hashtable-delete! procedure)
(eq-hashtable-ephemeron? procedure)
(eq-hashtable-ref procedure)
(eq-hashtable-set! procedure)
(eq-hashtable-update! procedure)
(eq-hashtable-weak? procedure)
(equal? procedure)
(equal-hash procedure)
(eqv? procedure)
(error procedure)
(error? procedure)
(errorf procedure)
(error-handling-mode syntax)
(eval procedure)
(eval-syntax-expanders-when thread-param)
(eval-when syntax)
(even? procedure)
(exact procedure)
(exact? procedure)
(exact->inexact procedure)
(exact-integer-sqrt procedure)
(except syntax)
(exclusive-cond syntax)
(exists procedure)
(exit procedure)
(exit-handler thread-param)
(exp procedure)
(expand procedure)
(expand/optimize procedure)
(expand/optimize-output thread-param)
(expand-output thread-param)
(export syntax)
(expression-editor module)
(expt procedure)
(expt-mod procedure)
(extend-syntax syntax)
(fasl-compressed thread-param)
(fasl-file procedure)
(fasl-read procedure)
(fasl-strip-options syntax)
(fasl-write procedure)
(fields syntax)
(file-access-time procedure)
(file-buffer-size thread-param)
(file-change-time procedure)
(file-directory? procedure)
(file-exists? procedure)
(file-length procedure)
(file-modification-time procedure)
(file-options syntax)
(file-port? procedure)
(file-position procedure)
(file-regular? procedure)
(file-symbolic-link? procedure)
(filter procedure)
(find procedure)
(finite? procedure)
(fixnum? procedure)
(fixnum->flonum procedure)
(fixnum-width procedure)
(fl- procedure)
(fl* procedure)
(fl/ procedure)
(fl+ procedure)
(fl< procedure)
(fl<? procedure)
(fl<= procedure)
(fl<=? procedure)
(fl= procedure)
(fl=? procedure)
(fl> procedure)
(fl>? procedure)
(fl>= procedure)
(fl>=? procedure)
(flabs procedure)
(flacos procedure)
(flasin procedure)
(flatan procedure)
(flceiling procedure)
(flcos procedure)
(fldenominator procedure)
(fldiv procedure)
(fldiv0 procedure)
(fldiv0-and-mod0 procedure)
(fldiv-and-mod procedure)
(fleven? procedure)
(flexp procedure)
(flexpt procedure)
(flfinite? procedure)
(flfloor procedure)
(flinfinite? procedure)
(flinteger? procedure)
(fllog procedure)
(fllp procedure)
(fl-make-rectangular procedure)
(flmax procedure)
(flmin procedure)
(flmod procedure)
(flmod0 procedure)
(flnan? procedure)
(flnegative? procedure)
(flnonnegative? procedure)
(flnonpositive? procedure)
(flnumerator procedure)
(flodd? procedure)
(flonum? procedure)
(flonum->fixnum procedure)
(floor procedure)
(flpositive? procedure)
(flround procedure)
(flsin procedure)
(flsqrt procedure)
(fltan procedure)
(fltruncate procedure)
(fluid-let syntax)
(fluid-let-syntax syntax)
(flush-output-port procedure)
(flzero? procedure)
(fold-left procedure)
(fold-right procedure)
(for-all procedure)
(force procedure)
(for-each procedure)
(foreign-address-name procedure)
(foreign-alloc procedure)
(foreign-callable syntax)
(foreign-callable-code-object procedure)
(foreign-callable-entry-point procedure)
(foreign-entry procedure)
(foreign-entry? procedure)
(foreign-free procedure)
(foreign-procedure syntax)
(foreign-ref procedure)
(foreign-set! procedure)
(foreign-sizeof procedure)
(fork-thread procedure)
(format procedure)
(format-condition? procedure)
(fprintf procedure)
(free-identifier=? procedure)
(fresh-line procedure)
(ftype-&ref syntax)
(ftype-guardian syntax)
(ftype-init-lock! syntax)
(ftype-lock! syntax)
(ftype-locked-decr! syntax)
(ftype-locked-incr! syntax)
(ftype-pointer? syntax)
(ftype-pointer=? syntax)
(ftype-pointer->sexpr procedure)
(ftype-pointer-address procedure)
(ftype-pointer-ftype procedure)
(ftype-pointer-null? syntax)
(ftype-ref syntax)
(ftype-set! syntax)
(ftype-sizeof syntax)
(ftype-spin-lock! syntax)
(ftype-unlock! syntax)
(fx- procedure)
(fx* procedure)
(fx*/carry procedure)
(fx/ procedure)
(fx-/carry procedure)
(fx+ procedure)
(fx+/carry procedure)
(fx< procedure)
(fx<? procedure)
(fx<= procedure)
(fx<=? procedure)
(fx= procedure)
(fx=? procedure)
(fx> procedure)
(fx>? procedure)
(fx>= procedure)
(fx>=? procedure)
(fx1- procedure)
(fx1+ procedure)
(fxabs procedure)
(fxand procedure)
(fxarithmetic-shift procedure)
(fxarithmetic-shift-left procedure)
(fxarithmetic-shift-right procedure)
(fxbit-count procedure)
(fxbit-field procedure)
(fxbit-set? procedure)
(fxcopy-bit procedure)
(fxcopy-bit-field procedure)
(fxdiv procedure)
(fxdiv0 procedure)
(fxdiv0-and-mod0 procedure)
(fxdiv-and-mod procedure)
(fxeven? procedure)
(fxfirst-bit-set procedure)
(fxif procedure)
(fxior procedure)
(fxlength procedure)
(fxlogand procedure)
(fxlogbit? procedure)
(fxlogbit0 procedure)
(fxlogbit1 procedure)
(fxlogior procedure)
(fxlognot procedure)
(fxlogor procedure)
(fxlogtest procedure)
(fxlogxor procedure)
(fxmax procedure)
(fxmin procedure)
(fxmod procedure)
(fxmod0 procedure)
(fxmodulo procedure)
(fxnegative? procedure)
(fxnonnegative? procedure)
(fxnonpositive? procedure)
(fxnot procedure)
(fxodd? procedure)
(fxpositive? procedure)
(fxquotient procedure)
(fxremainder procedure)
(fxreverse-bit-field procedure)
(fxrotate-bit-field procedure)
(fxsll procedure)
(fxsra procedure)
(fxsrl procedure)
(fxvector procedure)
(fxvector? procedure)
(fxvector->immutable-fxvector procedure)
(fxvector->list procedure)
(fxvector-copy procedure)
(fxvector-fill! procedure)
(fxvector-length procedure)
(fxvector-ref procedure)
(fxvector-set! procedure)
(fxxor procedure)
(fxzero? procedure)
(gcd procedure)
(generate-allocation-counts thread-param)
(generate-covin-files thread-param)
(generate-inspector-information thread-param)
(generate-instruction-counts thread-param)
(generate-interrupt-trap thread-param)
(generate-procedure-source-information thread-param)
(generate-profile-forms thread-param)
(generate-temporaries procedure)
(generate-wpo-files thread-param)
(gensym procedure)
(gensym? procedure)
(gensym->unique-string procedure)
(gensym-count thread-param)
(gensym-prefix thread-param)
(get-bytevector-all procedure)
(get-bytevector-n procedure)
(get-bytevector-n! procedure)
(get-bytevector-some procedure)
(get-bytevector-some! procedure)
(get-char procedure)
(get-datum procedure)
(get-datum/annotations procedure)
(getenv procedure)
(get-hash-table procedure)
(get-line procedure)
(get-mode procedure)
(get-output-string procedure)
(get-process-id procedure)
(getprop procedure)
(get-source-table! procedure)
(get-string-all procedure)
(get-string-n procedure)
(get-string-n! procedure)
(get-string-some procedure)
(get-string-some! procedure)
(get-thread-id procedure)
(get-u8 procedure)
(greatest-fixnum procedure)
(guard syntax)
(guardian? procedure)
(hashtable? procedure)
(hash-table? procedure)
(hashtable-cell procedure)
(hashtable-cells procedure)
(hashtable-clear! procedure)
(hashtable-contains? procedure)
(hashtable-copy procedure)
(hashtable-delete! procedure)
(hashtable-entries procedure)
(hashtable-ephemeron? procedure)
(hashtable-equivalence-function procedure)
(hash-table-for-each procedure)
(hashtable-hash-function procedure)
(hashtable-keys procedure)
(hash-table-map procedure)
(hashtable-mutable? procedure)
(hashtable-ref procedure)
(hashtable-set! procedure)
(hashtable-size procedure)
(hashtable-update! procedure)
(hashtable-values procedure)
(hashtable-weak? procedure)
(heap-reserve-ratio global-param)
(i/o-decoding-error? procedure)
(i/o-encoding-error? procedure)
(i/o-encoding-error-char procedure)
(i/o-error? procedure)
(i/o-error-filename procedure)
(i/o-error-port procedure)
(i/o-error-position procedure)
(i/o-file-already-exists-error? procedure)
(i/o-file-does-not-exist-error? procedure)
(i/o-file-is-read-only-error? procedure)
(i/o-filename-error? procedure)
(i/o-file-protection-error? procedure)
(i/o-invalid-position-error? procedure)
(i/o-port-error? procedure)
(i/o-read-error? procedure)
(i/o-write-error? procedure)
(iconv-codec procedure)
(identifier? procedure)
(identifier-syntax syntax)
(ieee module)
(ieee-environment procedure)
(if syntax)
(imag-part procedure)
(immutable syntax)
(immutable-box? procedure)
(immutable-bytevector? procedure)
(immutable-fxvector? procedure)
(immutable-string? procedure)
(immutable-vector? procedure)
(implementation-restriction-violation? procedure)
(implicit-exports syntax)
(import syntax)
(import-notify thread-param)
(import-only syntax)
(include syntax)
(indirect-export syntax)
(inexact procedure)
(inexact? procedure)
(inexact->exact procedure)
(infinite? procedure)
(initial-bytes-allocated procedure)
(input-port? procedure)
(input-port-ready? procedure)
(inspect procedure)
(inspect/object procedure)
(integer? procedure)
(integer->char procedure)
(integer-length procedure)
(integer-valued? procedure)
(interaction-environment thread-param)
(interactive? procedure)
(internal-defines-as-letrec* thread-param)
(interpret procedure)
(invoke-library procedure)
(iota procedure)
(irritants-condition? procedure)
(isqrt procedure)
(keyboard-interrupt-handler thread-param)
(lambda syntax)
(last-pair procedure)
(latin-1-codec procedure)
(lcm procedure)
(least-fixnum procedure)
(length procedure)
(let syntax)
(let* syntax)
(let*-values syntax)
(letrec syntax)
(letrec* syntax)
(letrec-syntax syntax)
(let-syntax syntax)
(let-values syntax)
(lexical-violation? procedure)
(library syntax)
(library-directories thread-param)
(library-exports procedure)
(library-extensions thread-param)
(library-list procedure)
(library-object-filename procedure)
(library-requirements procedure)
(library-requirements-options syntax)
(library-search-handler thread-param)
(library-version procedure)
(list procedure)
(list* procedure)
(list? procedure)
(list->fxvector procedure)
(list->string procedure)
(list->vector procedure)
(list-copy procedure)
(list-head procedure)
(list-instance procedure)
(list-ref procedure)
(list-sort procedure)
(list-tail procedure)
(literal-identifier=? procedure)
(load procedure)
(load-compiled-from-port procedure)
(load-library procedure)
(load-program procedure)
(load-shared-object procedure)
(locate-source procedure)
(locate-source-object-source procedure)
(locked-object? procedure)
(lock-object procedure)
(log procedure)
(logand procedure)
(logbit? procedure)
(logbit0 procedure)
(logbit1 procedure)
(logior procedure)
(lognot procedure)
(logor procedure)
(logtest procedure)
(logxor procedure)
(lookahead-char procedure)
(lookahead-u8 procedure)
(machine-type procedure)
(magnitude procedure)
(magnitude-squared procedure)
(make-annotation procedure)
(make-assertion-violation procedure)
(make-boot-file procedure)
(make-boot-header procedure)
(make-bytevector procedure)
(make-compile-time-value procedure)
(make-condition procedure)
(make-continuation-condition procedure)
(make-cost-center procedure)
(make-custom-binary-input/output-port procedure)
(make-custom-binary-input-port procedure)
(make-custom-binary-output-port procedure)
(make-custom-textual-input/output-port procedure)
(make-custom-textual-input-port procedure)
(make-custom-textual-output-port procedure)
(make-date procedure)
(make-engine procedure)
(make-enumeration procedure)
(make-ephemeron-eq-hashtable procedure)
(make-ephemeron-eqv-hashtable procedure)
(make-eq-hashtable procedure)
(make-eqv-hashtable procedure)
(make-error procedure)
(make-format-condition procedure)
(make-ftype-pointer syntax)
(make-fxvector procedure)
(make-guardian procedure)
(make-hashtable procedure)
(make-hash-table procedure)
(make-i/o-decoding-error procedure)
(make-i/o-encoding-error procedure)
(make-i/o-error procedure)
(make-i/o-file-already-exists-error procedure)
(make-i/o-file-does-not-exist-error procedure)
(make-i/o-file-is-read-only-error procedure)
(make-i/o-filename-error procedure)
(make-i/o-file-protection-error procedure)
(make-i/o-invalid-position-error procedure)
(make-i/o-port-error procedure)
(make-i/o-read-error procedure)
(make-i/o-write-error procedure)
(make-implementation-restriction-violation procedure)
(make-input/output-port procedure)
(make-input-port procedure)
(make-irritants-condition procedure)
(make-lexical-violation procedure)
(make-list procedure)
(make-message-condition procedure)
(make-mutex procedure)
(make-no-infinities-violation procedure)
(make-no-nans-violation procedure)
(make-non-continuable-violation procedure)
(make-object-finder procedure)
(make-output-port procedure)
(make-parameter procedure)
(make-polar procedure)
(make-record-constructor-descriptor procedure)
(make-record-type procedure)
(make-record-type-descriptor procedure)
(make-rectangular procedure)
(make-serious-condition procedure)
(make-source-condition procedure)
(make-source-file-descriptor procedure)
(make-source-object procedure)
(make-source-table procedure)
(make-sstats procedure)
(make-string procedure)
(make-syntax-violation procedure)
(make-thread-parameter procedure)
(make-time procedure)
(make-transcoder procedure)
(make-undefined-violation procedure)
(make-variable-transformer procedure)
(make-vector procedure)
(make-violation procedure)
(make-warning procedure)
(make-weak-eq-hashtable procedure)
(make-weak-eqv-hashtable procedure)
(make-who-condition procedure)
(map procedure)
(mark-port-closed! procedure)
(max procedure)
(maximum-memory-bytes procedure)
(maybe-compile-file procedure)
(maybe-compile-library procedure)
(maybe-compile-program procedure)
(member procedure)
(memp procedure)
(memq procedure)
(memv procedure)
(merge procedure)
(merge! procedure)
(message-condition? procedure)
(meta syntax)
(meta-cond syntax)
(min procedure)
(mkdir procedure)
(mod procedure)
(mod0 procedure)
(module syntax)
(modulo procedure)
(most-negative-fixnum procedure)
(most-positive-fixnum procedure)
(mutable syntax)
(mutable-box? procedure)
(mutable-bytevector? procedure)
(mutable-fxvector? procedure)
(mutable-string? procedure)
(mutable-vector? procedure)
(mutex? procedure)
(mutex-acquire procedure)
(mutex-name procedure)
(mutex-release procedure)
(nan? procedure)
(native-endianness procedure)
(native-eol-style procedure)
(native-transcoder procedure)
(negative? procedure)
(new-cafe procedure)
(newline procedure)
(no-infinities-violation? procedure)
(no-nans-violation? procedure)
(non-continuable-violation? procedure)
(nongenerative syntax)
(nonnegative? procedure)
(nonpositive? procedure)
(not procedure)
(null? procedure)
(null-environment procedure)
(number? procedure)
(number->string procedure)
(numerator procedure)
(object-counts procedure)
(oblist procedure)
(odd? procedure)
(only syntax)
(opaque syntax)
(open-bytevector-input-port procedure)
(open-bytevector-output-port procedure)
(open-fd-input/output-port procedure)
(open-fd-input-port procedure)
(open-fd-output-port procedure)
(open-file-input/output-port procedure)
(open-file-input-port procedure)
(open-file-output-port procedure)
(open-input-file procedure)
(open-input-output-file procedure)
(open-input-string procedure)
(open-output-file procedure)
(open-output-string procedure)
(open-process-ports procedure)
(open-source-file procedure)
(open-string-input-port procedure)
(open-string-output-port procedure)
(optimize-level thread-param)
(or syntax)
(ormap procedure)
(output-port? procedure)
(output-port-buffer-mode procedure)
(pair? procedure)
(parameterize syntax)
(parent syntax)
(parent-rtd syntax)
(pariah syntax)
(partition procedure)
(path-absolute? procedure)
(path-extension procedure)
(path-first procedure)
(path-last procedure)
(path-parent procedure)
(path-rest procedure)
(path-root procedure)
(peek-char procedure)
(petite? procedure)
(port? procedure)
(port-bol? procedure)
(port-closed? procedure)
(port-eof? procedure)
(port-file-compressed! procedure)
(port-file-descriptor procedure)
(port-handler procedure)
(port-has-port-length? procedure)
(port-has-port-nonblocking?? procedure)
(port-has-port-position? procedure)
(port-has-set-port-length!? procedure)
(port-has-set-port-nonblocking!? procedure)
(port-has-set-port-position!? procedure)
(port-input-buffer procedure)
(port-input-count procedure)
(port-input-empty? procedure)
(port-input-index procedure)
(port-input-size procedure)
(port-length procedure)
(port-name procedure)
(port-nonblocking? procedure)
(port-output-buffer procedure)
(port-output-count procedure)
(port-output-full? procedure)
(port-output-index procedure)
(port-output-size procedure)
(port-position procedure)
(port-transcoder procedure)
(positive? procedure)
(predicate syntax)
(prefix syntax)
(pretty-file procedure)
(pretty-format procedure)
(pretty-initial-indent thread-param)
(pretty-line-length thread-param)
(pretty-maximum-lines thread-param)
(pretty-one-line-limit thread-param)
(pretty-print procedure)
(pretty-standard-indent thread-param)
(print-brackets thread-param)
(print-char-name thread-param)
(print-extended-identifiers thread-param)
(printf procedure)
(print-gensym thread-param)
(print-graph thread-param)
(print-length thread-param)
(print-level thread-param)
(print-precision thread-param)
(print-radix thread-param)
(print-record thread-param)
(print-unicode thread-param)
(print-vector-length thread-param)
(procedure? procedure)
(procedure-arity-mask procedure)
(process procedure)
(profile syntax)
(profile-clear procedure)
(profile-clear-database procedure)
(profile-dump procedure)
(profile-dump-data procedure)
(profile-dump-html procedure)
(profile-dump-list procedure)
(profile-line-number-color thread-param)
(profile-load-data procedure)
(profile-palette thread-param)
(profile-query-weight procedure)
(profile-release-counters procedure)
(property-list procedure)
(protocol syntax)
(put-bytevector procedure)
(put-bytevector-some procedure)
(put-char procedure)
(put-datum procedure)
(putenv procedure)
(put-hash-table! procedure)
(putprop procedure)
(put-source-table procedure)
(put-string procedure)
(put-string-some procedure)
(put-u8 procedure)
(quasiquote syntax)
(quasisyntax syntax)
(quote syntax)
(quotient procedure)
(r5rs module)
(r5rs-syntax module)
(r6rs:< procedure)
(r6rs:<= procedure)
(r6rs:= procedure)
(r6rs:> procedure)
(r6rs:>= procedure)
(r6rs:call-with-input-file procedure)
(r6rs:call-with-output-file procedure)
(r6rs:case procedure)
(r6rs:char<? procedure)
(r6rs:char<=? procedure)
(r6rs:char=? procedure)
(r6rs:char>? procedure)
(r6rs:char>=? procedure)
(r6rs:char-ci<? procedure)
(r6rs:char-ci<=? procedure)
(r6rs:char-ci=? procedure)
(r6rs:char-ci>? procedure)
(r6rs:char-ci>=? procedure)
(r6rs:command-line procedure)
(r6rs:current-error-port procedure)
(r6rs:current-input-port procedure)
(r6rs:current-output-port procedure)
(r6rs:delete-file procedure)
(r6rs:dynamic-wind procedure)
(r6rs:eval procedure)
(r6rs:exit procedure)
(r6rs:file-exists? procedure)
(r6rs:flush-output-port procedure)
(r6rs:fx- procedure)
(r6rs:fx* procedure)
(r6rs:fx+ procedure)
(r6rs:hashtable-entries procedure)
(r6rs:hashtable-keys procedure)
(r6rs:number->string procedure)
(r6rs:open-input-file procedure)
(r6rs:open-output-file procedure)
(r6rs:record? procedure)
(r6rs:record-constructor procedure)
(r6rs:standard-error-port procedure)
(r6rs:standard-input-port procedure)
(r6rs:standard-output-port procedure)
(r6rs:string<? procedure)
(r6rs:string<=? procedure)
(r6rs:string=? procedure)
(r6rs:string>? procedure)
(r6rs:string>=? procedure)
(r6rs:string->number procedure)
(r6rs:string-ci<? procedure)
(r6rs:string-ci<=? procedure)
(r6rs:string-ci=? procedure)
(r6rs:string-ci>? procedure)
(r6rs:string-ci>=? procedure)
(r6rs:syntax-rules procedure)
(r6rs:utf-16-codec procedure)
(r6rs:with-input-from-file procedure)
(r6rs:with-output-to-file procedure)
(raise procedure)
(raise-continuable procedure)
(random procedure)
(random-seed thread-param)
(rational? procedure)
(rationalize procedure)
(rational-valued? procedure)
(ratnum? procedure)
(read procedure)
(read-char procedure)
(read-token procedure)
(real? procedure)
(real->flonum procedure)
(real-part procedure)
(real-time procedure)
(real-valued? procedure)
(rec syntax)
(record? procedure)
(record-accessor procedure)
(record-case syntax)
(record-constructor procedure)
(record-constructor-descriptor syntax)
(record-constructor-descriptor? procedure)
(record-equal-procedure procedure)
(record-field-mutable? procedure)
(record-hash-procedure procedure)
(record-mutator procedure)
(record-predicate procedure)
(record-reader procedure)
(record-rtd procedure)
(record-type-descriptor procedure)
(record-type-descriptor? procedure)
(record-type-equal-procedure procedure)
(record-type-field-names procedure)
(record-type-generative? procedure)
(record-type-hash-procedure procedure)
(record-type-name procedure)
(record-type-opaque? procedure)
(record-type-parent procedure)
(record-type-sealed? procedure)
(record-type-uid procedure)
(record-writer procedure)
(register-signal-handler procedure)
(release-minimum-generation global-param)
(remainder procedure)
(remove procedure)
(remove! procedure)
(remove-foreign-entry procedure)
(remove-hash-table! procedure)
(remp procedure)
(remprop procedure)
(remq procedure)
(remq! procedure)
(remv procedure)
(remv! procedure)
(rename syntax)
(rename-file procedure)
(require-nongenerative-clause thread-param)
(reset procedure)
(reset-cost-center! procedure)
(reset-handler thread-param)
(reset-maximum-memory-bytes! procedure)
(reverse procedure)
(reverse! procedure)
(revisit procedure)
(revisit-compiled-from-port procedure)
(rnrs procedure)
(round procedure)
(run-cp0 thread-param)
(s8-list->bytevector procedure)
(sc-expand procedure)
(scheme module)
(scheme-environment procedure)
(scheme-program global-param)
(scheme-report-environment procedure)
(scheme-script global-param)
(scheme-start global-param)
(scheme-version procedure)
(scheme-version-number procedure)
(sealed syntax)
(serious-condition? procedure)
(set! syntax)
(set-binary-port-input-buffer! procedure)
(set-binary-port-input-index! procedure)
(set-binary-port-input-size! procedure)
(set-binary-port-output-buffer! procedure)
(set-binary-port-output-index! procedure)
(set-binary-port-output-size! procedure)
(set-box! procedure)
(set-car! procedure)
(set-cdr! procedure)
(set-port-bol! procedure)
(set-port-eof! procedure)
(set-port-input-buffer! procedure)
(set-port-input-index! procedure)
(set-port-input-size! procedure)
(set-port-length! procedure)
(set-port-name! procedure)
(set-port-nonblocking! procedure)
(set-port-output-buffer! procedure)
(set-port-output-index! procedure)
(set-port-output-size! procedure)
(set-port-position! procedure)
(set-sstats-bytes! procedure)
(set-sstats-cpu! procedure)
(set-sstats-gc-bytes! procedure)
(set-sstats-gc-count! procedure)
(set-sstats-gc-cpu! procedure)
(set-sstats-gc-real! procedure)
(set-sstats-real! procedure)
(set-textual-port-input-buffer! procedure)
(set-textual-port-input-index! procedure)
(set-textual-port-input-size! procedure)
(set-textual-port-output-buffer! procedure)
(set-textual-port-output-index! procedure)
(set-textual-port-output-size! procedure)
(set-time-nanosecond! procedure)
(set-timer procedure)
(set-time-second! procedure)
(set-time-type! procedure)
(set-top-level-value! procedure)
(set-virtual-register! procedure)
(simple-conditions procedure)
(sin procedure)
(sinh procedure)
(sint-list->bytevector procedure)
(sleep procedure)
(sort procedure)
(sort! procedure)
(source-condition? procedure)
(source-condition-form procedure)
(source-directories global-param)
(source-file-descriptor procedure)
(source-file-descriptor? procedure)
(source-file-descriptor-checksum procedure)
(source-file-descriptor-path procedure)
(source-object? procedure)
(source-object-bfp procedure)
(source-object-column procedure)
(source-object-efp procedure)
(source-object-line procedure)
(source-object-sfd procedure)
(source-table? procedure)
(source-table-cell procedure)
(source-table-contains? procedure)
(source-table-delete! procedure)
(source-table-dump procedure)
(source-table-ref procedure)
(source-table-set! procedure)
(source-table-size procedure)
(sqrt procedure)
(sstats? procedure)
(sstats-bytes procedure)
(sstats-cpu procedure)
(sstats-difference procedure)
(sstats-gc-bytes procedure)
(sstats-gc-count procedure)
(sstats-gc-cpu procedure)
(sstats-gc-real procedure)
(sstats-print procedure)
(sstats-real procedure)
(standard-error-port procedure)
(standard-input-port procedure)
(standard-output-port procedure)
(statistics procedure)
(string procedure)
(string? procedure)
(string<? procedure)
(string<=? procedure)
(string=? procedure)
(string>? procedure)
(string>=? procedure)
(string->bytevector procedure)
(string->immutable-string procedure)
(string->list procedure)
(string->number procedure)
(string->symbol procedure)
(string->utf16 procedure)
(string->utf32 procedure)
(string->utf8 procedure)
(string-append procedure)
(string-ci<? procedure)
(string-ci<=? procedure)
(string-ci=? procedure)
(string-ci>? procedure)
(string-ci>=? procedure)
(string-ci-hash procedure)
(string-copy procedure)
(string-copy! procedure)
(string-downcase procedure)
(string-fill! procedure)
(string-foldcase procedure)
(string-for-each procedure)
(string-hash procedure)
(string-length procedure)
(string-normalize-nfc procedure)
(string-normalize-nfd procedure)
(string-normalize-nfkc procedure)
(string-normalize-nfkd procedure)
(string-ref procedure)
(string-set! procedure)
(string-titlecase procedure)
(string-truncate! procedure)
(string-upcase procedure)
(strip-fasl-file procedure)
(sub1 procedure)
(subset-mode thread-param)
(subst procedure)
(subst! procedure)
(substq procedure)
(substq! procedure)
(substring procedure)
(substring-fill! procedure)
(substv procedure)
(substv! procedure)
(subtract-duration procedure)
(subtract-duration! procedure)
(suppress-greeting global-param)
(symbol? procedure)
(symbol=? procedure)
(symbol->string procedure)
(symbol-hash procedure)
(symbol-hashtable? procedure)
(symbol-hashtable-cell procedure)
(symbol-hashtable-contains? procedure)
(symbol-hashtable-delete! procedure)
(symbol-hashtable-ref procedure)
(symbol-hashtable-set! procedure)
(symbol-hashtable-update! procedure)
(syntax syntax)
(syntax->annotation procedure)
(syntax->datum procedure)
(syntax->list procedure)
(syntax->vector procedure)
(syntax-case syntax)
(syntax-error procedure)
(syntax-object->datum procedure)
(syntax-rules syntax)
(syntax-violation procedure)
(syntax-violation? procedure)
(syntax-violation-form procedure)
(syntax-violation-subform procedure)
(system procedure)
(tan procedure)
(tanh procedure)
(textual-port? procedure)
(textual-port-input-buffer procedure)
(textual-port-input-count procedure)
(textual-port-input-index procedure)
(textual-port-input-size procedure)
(textual-port-output-buffer procedure)
(textual-port-output-count procedure)
(textual-port-output-index procedure)
(textual-port-output-size procedure)
(thread? procedure)
(thread-condition? procedure)
(threaded? procedure)
(time syntax)
(time? procedure)
(time<? procedure)
(time<=? procedure)
(time=? procedure)
(time>? procedure)
(time>=? procedure)
(time-difference procedure)
(time-difference! procedure)
(time-nanosecond procedure)
(timer-interrupt-handler thread-param)
(time-second procedure)
(time-type procedure)
(time-utc->date procedure)
(top-level-bound? procedure)
(top-level-mutable? procedure)
(top-level-program syntax)
(top-level-syntax procedure)
(top-level-syntax? procedure)
(top-level-value procedure)
(trace syntax)
(trace-case-lambda syntax)
(trace-define syntax)
(trace-define-syntax syntax)
(trace-do syntax)
(trace-lambda syntax)
(trace-let syntax)
(trace-output-port thread-param)
(trace-print thread-param)
(transcoded-port procedure)
(transcoder? procedure)
(transcoder-codec procedure)
(transcoder-eol-style procedure)
(transcoder-error-handling-mode procedure)
(transcript-cafe procedure)
(transcript-off procedure)
(transcript-on procedure)
(truncate procedure)
(truncate-file procedure)
(truncate-port procedure)
(type-descriptor syntax)
(u8-list->bytevector procedure)
(uint-list->bytevector procedure)
(unbox procedure)
(undefined-variable-warnings thread-param)
(undefined-violation? procedure)
(unget-char procedure)
(unget-u8 procedure)
(unless syntax)
(unlock-object procedure)
(unquote syntax)
(unquote-splicing syntax)
(unread-char procedure)
(unregister-guardian procedure)
(unsyntax syntax)
(unsyntax-splicing syntax)
(untrace syntax)
(utf16->string procedure)
(utf-16be-codec procedure)
(utf-16-codec procedure)
(utf-16le-codec procedure)
(utf32->string procedure)
(utf8->string procedure)
(utf-8-codec procedure)
(values procedure)
(vector procedure)
(vector? procedure)
(vector->immutable-vector procedure)
(vector->list procedure)
(vector-cas! procedure)
(vector-copy procedure)
(vector-fill! procedure)
(vector-for-each procedure)
(vector-length procedure)
(vector-map procedure)
(vector-ref procedure)
(vector-set! procedure)
(vector-set-fixnum! procedure)
(vector-sort procedure)
(vector-sort! procedure)
(verify-loadability procedure)
(violation? procedure)
(virtual-register procedure)
(virtual-register-count procedure)
(visit procedure)
(visit-compiled-from-port procedure)
(void procedure)
(waiter-prompt-and-read thread-param)
(waiter-prompt-string thread-param)
(waiter-write thread-param)
(warning procedure)
(warning? procedure)
(warningf procedure)
(weak-cons procedure)
(weak-pair? procedure)
(when syntax)
(who-condition? procedure)
(with-cost-center procedure)
(with-exception-handler procedure)
(with-implicit syntax)
(with-input-from-file procedure)
(with-input-from-string procedure)
(with-interrupts-disabled syntax)
(with-mutex syntax)
(with-output-to-file procedure)
(with-output-to-string procedure)
(with-profile-tracker procedure)
(with-source-path procedure)
(with-syntax syntax)
(write procedure)
(write-char procedure)
(zero? procedure)))) 

(define rnrs-conditions (private-process '(rnrs conditions) '(
(&assertion	syntax)
(&condition	syntax)
(&error	syntax)
(&implementation-restriction	syntax)
(&irritants	syntax)
(&lexical	syntax)
(&message	syntax)
(&non-continuable	syntax)
(&serious	syntax)
(&syntax	syntax)
(&undefined	syntax)
(&violation	syntax)
(&warning	syntax)
(&who	syntax)
(assertion-violation?	procedure)
(condition	procedure)
(condition-accessor	procedure)
(condition-irritants	procedure)
(condition-message	procedure)
(condition-predicate	procedure)
(condition-who	procedure)
(condition?	procedure)
(define-condition-type	syntax)
(error?	procedure)
(implementation-restriction-violation?	procedure)
(irritants-condition?	procedure)
(lexical-violation?	procedure)
(make-assertion-violation	procedure)
(make-error	procedure)
(make-implementation-restriction-violation	procedure)
(make-irritants-condition	procedure)
(make-lexical-violation	procedure)
(make-message-condition	procedure)
(make-non-continuable-violation	procedure)
(make-serious-condition	procedure)
(make-syntax-violation	procedure)
(make-undefined-violation	procedure)
(make-violation	procedure)
(make-warning	procedure)
(make-who-condition	procedure)
(message-condition?	procedure)
(non-continuable-violation?	procedure)
(serious-condition?	procedure)
(simple-conditions	procedure)
(syntax-violation-form	procedure)
(syntax-violation-subform	procedure)
(syntax-violation?	procedure)
(undefined-violation?	procedure)
(violation?	procedure)
(warning?	procedure)
(who-condition?	procedure))))

(define rnrs-files (private-process '(rnrs files) '(
(&i/o	syntax)
(&i/o-file-already-exists	syntax)
(&i/o-file-does-not-exist	syntax)
(&i/o-file-is-read-only	syntax)
(&i/o-file-protection	syntax)
(&i/o-filename	syntax)
(&i/o-invalid-position	syntax)
(&i/o-port	syntax)
(&i/o-read	syntax)
(&i/o-write	syntax)
(i/o-error-filename	procedure)
(i/o-error-port	procedure)
(i/o-error-position	procedure)
(i/o-error?	procedure)
(i/o-file-already-exists-error?	procedure)
(i/o-file-does-not-exist-error?	procedure)
(i/o-file-is-read-only-error?	procedure)
(i/o-file-protection-error?	procedure)
(i/o-filename-error?	procedure)
(i/o-invalid-position-error?	procedure)
(i/o-port-error?	procedure)
(i/o-read-error?	procedure)
(i/o-write-error?	procedure)
(make-i/o-error	procedure)
(make-i/o-file-already-exists-error	procedure)
(make-i/o-file-does-not-exist-error	procedure)
(make-i/o-file-is-read-only-error	procedure)
(make-i/o-file-protection-error	procedure)
(make-i/o-filename-error	procedure)
(make-i/o-invalid-position-error	procedure)
(make-i/o-port-error	procedure)
(make-i/o-read-error	procedure)
(make-i/o-write-error	procedure)
(delete-file	procedure)
(file-exists?	procedure)
)))

(define rnrs-base (private-process '(rnrs base) '(
(+	procedure)
(*	procedure)
(-	procedure)
(...	syntax)
(/	procedure)
(=>	syntax)
(_	syntax)
(abs	procedure)
(acos	procedure)
(and	syntax)
(angle	procedure)
(append	procedure)
(apply	procedure)
(asin	procedure)
(assert	syntax)
(assertion-violation	procedure)
(atan	procedure)
(begin	syntax)
(boolean=?	procedure)
(boolean?	procedure)
(caaaar	procedure)
(caaadr	procedure)
(caaar	procedure)
(caadar	procedure)
(caaddr	procedure)
(caadr	procedure)
(caar	procedure)
(cadaar	procedure)
(cadadr	procedure)
(cadar	procedure)
(caddar	procedure)
(cadddr	procedure)
(caddr	procedure)
(cadr	procedure)
(call-with-current-continuation	procedure)
(call-with-values	procedure)
(call/cc	procedure)
(car	procedure)
(cdaaar	procedure)
(cdaadr	procedure)
(cdaar	procedure)
(cdadar	procedure)
(cdaddr	procedure)
(cdadr	procedure)
(cdar	procedure)
(cddaar	procedure)
(cddadr	procedure)
(cddar	procedure)
(cdddar	procedure)
(cddddr	procedure)
(cdddr	procedure)
(cddr	procedure)
(cdr	procedure)
(ceiling	procedure)
(char->integer	procedure)
(char?	procedure)
(complex?	procedure)
(cond	syntax)
(cons	procedure)
(cos	procedure)
(define	syntax)
(define-syntax	syntax)
(denominator	procedure)
(div	procedure)
(div-and-mod	procedure)
(div0	procedure)
(div0-and-mod0	procedure)
(else	syntax)
(eq?	procedure)
(equal?	procedure)
(eqv?	procedure)
(error	procedure)
(even?	procedure)
(exact	procedure)
(exact-integer-sqrt	procedure)
(exact?	procedure)
(exp	procedure)
(expt	procedure)
(finite?	procedure)
(floor	procedure)
(for-each	procedure)
(gcd	procedure)
(identifier-syntax	syntax)
(if	syntax)
(imag-part	procedure)
(inexact	procedure)
(inexact?	procedure)
(infinite?	procedure)
(integer->char	procedure)
(integer-valued?	procedure)
(integer?	procedure)
(lambda	syntax)
(lcm	procedure)
(length	procedure)
(let	syntax)
(let*	syntax)
(let*-values	syntax)
(let-syntax	syntax)
(let-values	syntax)
(letrec	syntax)
(letrec*	syntax)
(letrec-syntax	syntax)
(list	procedure)
(list->string	procedure)
(list->vector	procedure)
(list-ref	procedure)
(list-tail	procedure)
(list?	procedure)
(log	procedure)
(magnitude	procedure)
(make-polar	procedure)
(make-rectangular	procedure)
(make-string	procedure)
(make-vector	procedure)
(map	procedure)
(max	procedure)
(min	procedure)
(mod	procedure)
(mod0	procedure)
(nan?	procedure)
(negative?	procedure)
(not	procedure)
(null?	procedure)
(number?	procedure)
(numerator	procedure)
(odd?	procedure)
(or	syntax)
(pair?	procedure)
(positive?	procedure)
(procedure?	procedure)
(quasiquote	syntax)
(quote	syntax)
(<	procedure)
(<=	procedure)
(=	procedure)
(>	procedure)
(>=	procedure)
(case	syntax)
(char<=?	procedure)
(char<?	procedure)
(char=?	procedure)
(char>=?	procedure)
(char>?	procedure)
(dynamic-wind	procedure)
(number->string	procedure)
(string->number	procedure)
(string<=?	procedure)
(string<?	procedure)
(string=?	procedure)
(string>=?	procedure)
(string>?	procedure)
(syntax-rules	syntax)
(rational-valued?	procedure)
(rational?	procedure)
(rationalize	procedure)
(real-part	procedure)
(real-valued?	procedure)
(real?	procedure)
(reverse	procedure)
(round	procedure)
(set!	syntax)
(sin	procedure)
(sqrt	procedure)
(string	procedure)
(string->list	procedure)
(string->symbol	procedure)
(string-append	procedure)
(string-copy	procedure)
(string-for-each	procedure)
(string-length	procedure)
(string-ref	procedure)
(string?	procedure)
(substring	procedure)
(symbol->string	procedure)
(symbol=?	procedure)
(symbol?	procedure)
(tan	procedure)
(truncate	procedure)
(unquote	syntax)
(unquote-splicing	syntax)
(values	procedure)
(vector	procedure)
(vector->list	procedure)
(vector-fill!	procedure)
(vector-for-each	procedure)
(vector-length	procedure)
(vector-map	procedure)
(vector-ref	procedure)
(vector-set!	procedure)
(vector?	procedure)
(zero?	procedure))))

(define rnrs-syntax-case (private-process '(rnrs syntax case) '(
(...	syntax)
(_	syntax)
(bound-identifier=?	procedure)
(datum->syntax	procedure)
(free-identifier=?	procedure)
(generate-temporaries	procedure)
(identifier?	procedure)
(make-variable-transformer	procedure)
(quasisyntax	syntax)
(syntax	syntax)
(syntax->datum	procedure)
(syntax-case	syntax)
(syntax-violation	procedure)
(unsyntax	syntax)
(unsyntax-splicing	syntax)
(with-syntax	syntax))))

(define rnrs-exceptions (private-process '(rnrs exceptions) '(
(=>	syntax)
(else	syntax)
(guard	syntax)
(raise	procedure)
(raise-continuable	procedure)
(with-exception-handler	procedure))))

(define rnrs-lists (private-process '(rnrs lists) '(
(assoc	procedure)
(assp	procedure)
(assq	procedure)
(assv	procedure)
(cons*	procedure)
(exists	procedure)
(filter	procedure)
(find	procedure)
(fold-left	procedure)
(fold-right	procedure)
(for-all	procedure)
(member	procedure)
(memp	procedure)
(memq	procedure)
(memv	procedure)
(partition	procedure)
(remove	procedure)
(remp	procedure)
(remq	procedure)
(remv	procedure))))

(define rnrs-bytevectors (private-process '(rnrs bytevectors) '(
(bytevector->sint-list	procedure)
(bytevector->u8-list	procedure)
(bytevector->uint-list	procedure)
(bytevector-copy	procedure)
(bytevector-copy!	procedure)
(bytevector-fill!	procedure)
(bytevector-ieee-double-native-ref	procedure)
(bytevector-ieee-double-native-set!	procedure)
(bytevector-ieee-double-ref	procedure)
(bytevector-ieee-double-set!	procedure)
(bytevector-ieee-single-native-ref	procedure)
(bytevector-ieee-single-native-set!	procedure)
(bytevector-ieee-single-ref	procedure)
(bytevector-ieee-single-set!	procedure)
(bytevector-length	procedure)
(bytevector-s16-native-ref	procedure)
(bytevector-s16-native-set!	procedure)
(bytevector-s16-ref	procedure)
(bytevector-s16-set!	procedure)
(bytevector-s32-native-ref	procedure)
(bytevector-s32-native-set!	procedure)
(bytevector-s32-ref	procedure)
(bytevector-s32-set!	procedure)
(bytevector-s64-native-ref	procedure)
(bytevector-s64-native-set!	procedure)
(bytevector-s64-ref	procedure)
(bytevector-s64-set!	procedure)
(bytevector-s8-ref	procedure)
(bytevector-s8-set!	procedure)
(bytevector-sint-ref	procedure)
(bytevector-sint-set!	procedure)
(bytevector-u16-native-ref	procedure)
(bytevector-u16-native-set!	procedure)
(bytevector-u16-ref	procedure)
(bytevector-u16-set!	procedure)
(bytevector-u32-native-ref	procedure)
(bytevector-u32-native-set!	procedure)
(bytevector-u32-ref	procedure)
(bytevector-u32-set!	procedure)
(bytevector-u64-native-ref	procedure)
(bytevector-u64-native-set!	procedure)
(bytevector-u64-ref	procedure)
(bytevector-u64-set!	procedure)
(bytevector-u8-ref	procedure)
(bytevector-u8-set!	procedure)
(bytevector-uint-ref	procedure)
(bytevector-uint-set!	procedure)
(bytevector=?	procedure)
(bytevector?	procedure)
(endianness	syntax)
(make-bytevector	procedure)
(native-endianness	procedure)
(sint-list->bytevector	procedure)
(string->utf16	procedure)
(string->utf32	procedure)
(string->utf8	procedure)
(u8-list->bytevector	procedure)
(uint-list->bytevector	procedure)
(utf16->string	procedure)
(utf32->string	procedure)
(utf8->string	procedure))))

(define rnrs-control (private-process '(rnrs control) '(
(case-lambda	syntax)
(do	syntax)
(unless	syntax)
(when	syntax))))

(define rnrs-unicode (private-process '(rnrs unicode) '(
(char-alphabetic?	procedure)
(char-downcase	procedure)
(char-foldcase	procedure)
(char-general-category	procedure)
(char-lower-case?	procedure)
(char-numeric?	procedure)
(char-title-case?	procedure)
(char-titlecase	procedure)
(char-upcase	procedure)
(char-upper-case?	procedure)
(char-whitespace?	procedure)
(char-ci<=?	procedure)
(char-ci<?	procedure)
(char-ci=?	procedure)
(char-ci>=?	procedure)
(char-ci>?	procedure)
(string-ci<=?	procedure)
(string-ci<?	procedure)
(string-ci=?	procedure)
(string-ci>=?	procedure)
(string-ci>?	procedure)
(string-downcase	procedure)
(string-foldcase	procedure)
(string-normalize-nfc	procedure)
(string-normalize-nfd	procedure)
(string-normalize-nfkc	procedure)
(string-normalize-nfkd	procedure)
(string-titlecase	procedure)
(string-upcase	procedure))))

(define rnrs-enums (private-process '(rnrs enums) '(
(define-enumeration	syntax)
(enum-set->list	procedure)
(enum-set-complement	procedure)
(enum-set-constructor	procedure)
(enum-set-difference	procedure)
(enum-set-indexer	procedure)
(enum-set-intersection	procedure)
(enum-set-member?	procedure)
(enum-set-projection	procedure)
(enum-set-subset?	procedure)
(enum-set-union	procedure)
(enum-set-universe	procedure)
(enum-set=?	procedure)
(make-enumeration	procedure))))

(define rnrs-r5rs (private-process '(rnrs r5rs) '(
(delay	syntax)
(exact->inexact	procedure)
(force	procedure)
(inexact->exact	procedure)
(modulo	procedure)
(null-environment	procedure)
(quotient	procedure)
(remainder	procedure)
(scheme-report-environment	procedure))))

(define rnrs-eval (private-process '(rnrs eval) '(
(environment	procedure)
(eval	procedure))))

(define rnrs-hashtables (private-process '(rnrs hashtables) '(
(equal-hash	procedure)
(hashtable-clear!	procedure)
(hashtable-contains?	procedure)
(hashtable-copy	procedure)
(hashtable-delete!	procedure)
(hashtable-equivalence-function	procedure)
(hashtable-hash-function	procedure)
(hashtable-mutable?	procedure)
(hashtable-ref	procedure)
(hashtable-set!	procedure)
(hashtable-size	procedure)
(hashtable-update!	procedure)
(hashtable?	procedure)
(make-eq-hashtable	procedure)
(make-eqv-hashtable	procedure)
(make-hashtable	procedure)
(hashtable-entries	procedure)
(hashtable-keys	procedure)
(string-ci-hash	procedure)
(string-hash	procedure)
(symbol-hash	procedure))))

(define rnrs-sorting (private-process '(rnrs sorting) '(
(list-sort	procedure)
(vector-sort	procedure)
(vector-sort!	procedure)
)))

(define rnrs-programs (private-process '(rnrs programs) '(
(command-line	global-param)
(exit	procedure)
)))

(define rnrs-mutable-pairs (private-process '(rnrs mutable pairs) '(
(set-car!	procedure)
(set-cdr!	procedure))))

(define rnrs-mutable-strings (private-process '(rnrs mutable strings) '(
(string-fill!	procedure)
(string-set!	procedure))))

(define rnrs-io-ports (private-process '(rnrs io ports) '(
(&i/o	syntax)
(&i/o-decoding	syntax)
(&i/o-encoding	syntax)
(&i/o-file-already-exists	syntax)
(&i/o-file-does-not-exist	syntax)
(&i/o-file-is-read-only	syntax)
(&i/o-file-protection	syntax)
(&i/o-filename	syntax)
(&i/o-invalid-position	syntax)
(&i/o-port	syntax)
(&i/o-read	syntax)
(&i/o-write	syntax)
(binary-port?	procedure)
(buffer-mode	syntax)
(buffer-mode?	syntax)
(bytevector->string	procedure)
(call-with-bytevector-output-port	procedure)
(call-with-port	procedure)
(call-with-string-output-port	procedure)
(close-port	procedure)
(eof-object	procedure)
(eof-object?	procedure)
(eol-style	syntax)
(error-handling-mode	syntax)
(file-options	syntax)
(get-bytevector-all	procedure)
(get-bytevector-n	procedure)
(get-bytevector-n!	procedure)
(get-bytevector-some	procedure)
(get-char	procedure)
(get-datum	procedure)
(get-line	procedure)
(get-string-all	procedure)
(get-string-n	procedure)
(get-string-n!	procedure)
(get-u8	procedure)
(i/o-decoding-error?	procedure)
(i/o-encoding-error-char	procedure)
(i/o-encoding-error?	procedure)
(i/o-error-filename	procedure)
(i/o-error-port	procedure)
(i/o-error-position	procedure)
(i/o-error?	procedure)
(i/o-file-already-exists-error?	procedure)
(i/o-file-does-not-exist-error?	procedure)
(i/o-file-is-read-only-error?	procedure)
(i/o-file-protection-error?	procedure)
(i/o-filename-error?	procedure)
(i/o-invalid-position-error?	procedure)
(i/o-port-error?	procedure)
(i/o-read-error?	procedure)
(i/o-write-error?	procedure)
(input-port?	procedure)
(latin-1-codec	procedure)
(lookahead-char	procedure)
(lookahead-u8	procedure)
(make-custom-binary-input-port	procedure)
(make-custom-binary-input/output-port	procedure)
(make-custom-binary-output-port	procedure)
(make-custom-textual-input-port	procedure)
(make-custom-textual-input/output-port	procedure)
(make-custom-textual-output-port	procedure)
(make-i/o-decoding-error	procedure)
(make-i/o-encoding-error	procedure)
(make-i/o-error	procedure)
(make-i/o-file-already-exists-error	procedure)
(make-i/o-file-does-not-exist-error	procedure)
(make-i/o-file-is-read-only-error	procedure)
(make-i/o-file-protection-error	procedure)
(make-i/o-filename-error	procedure)
(make-i/o-invalid-position-error	procedure)
(make-i/o-port-error	procedure)
(make-i/o-read-error	procedure)
(make-i/o-write-error	procedure)
(make-transcoder	procedure)
(native-eol-style	procedure)
(native-transcoder	procedure)
(open-bytevector-input-port	procedure)
(open-bytevector-output-port	procedure)
(open-file-input-port	procedure)
(open-file-input/output-port	procedure)
(open-file-output-port	procedure)
(open-string-input-port	procedure)
(open-string-output-port	procedure)
(output-port-buffer-mode	procedure)
(output-port?	procedure)
(port-eof?	procedure)
(port-has-port-position?	procedure)
(port-has-set-port-position!?	procedure)
(port-position	procedure)
(port-transcoder	procedure)
(port?	procedure)
(put-bytevector	procedure)
(put-char	procedure)
(put-datum	procedure)
(put-string	procedure)
(put-u8	procedure)
(current-error-port	thread-param)
(current-input-port	thread-param)
(current-output-port	thread-param)
(flush-output-port	procedure)
(standard-error-port	procedure)
(standard-input-port	procedure)
(standard-output-port	procedure)
(utf-16-codec	procedure)
(set-port-position!	procedure)
(string->bytevector	procedure)
(textual-port?	procedure)
(transcoded-port	procedure)
(transcoder-codec	procedure)
(transcoder-eol-style	procedure)
(transcoder-error-handling-mode	procedure)
(utf-8-codec	procedure))))

(define rnrs-io-simple (private-process '(rnrs io simple) '(
(&i/o	syntax)
(&i/o-file-already-exists	syntax)
(&i/o-file-does-not-exist	syntax)
(&i/o-file-is-read-only	syntax)
(&i/o-file-protection	syntax)
(&i/o-filename	syntax)
(&i/o-invalid-position	syntax)
(&i/o-port	syntax)
(&i/o-read	syntax)
(&i/o-write	syntax)
(close-input-port	procedure)
(close-output-port	procedure)
(display	procedure)
(eof-object	procedure)
(eof-object?	procedure)
(i/o-error-filename	procedure)
(i/o-error-port	procedure)
(i/o-error-position	procedure)
(i/o-error?	procedure)
(i/o-file-already-exists-error?	procedure)
(i/o-file-does-not-exist-error?	procedure)
(i/o-file-is-read-only-error?	procedure)
(i/o-file-protection-error?	procedure)
(i/o-filename-error?	procedure)
(i/o-invalid-position-error?	procedure)
(i/o-port-error?	procedure)
(i/o-read-error?	procedure)
(i/o-write-error?	procedure)
(input-port?	procedure)
(make-i/o-error	procedure)
(make-i/o-file-already-exists-error	procedure)
(make-i/o-file-does-not-exist-error	procedure)
(make-i/o-file-is-read-only-error	procedure)
(make-i/o-file-protection-error	procedure)
(make-i/o-filename-error	procedure)
(make-i/o-invalid-position-error	procedure)
(make-i/o-port-error	procedure)
(make-i/o-read-error	procedure)
(make-i/o-write-error	procedure)
(newline	procedure)
(output-port?	procedure)
(peek-char	procedure)
(call-with-input-file	procedure)
(call-with-output-file	procedure)
(current-error-port	thread-param)
(current-input-port	thread-param)
(current-output-port	thread-param)
(open-input-file	procedure)
(open-output-file	procedure)
(with-input-from-file	procedure)
(with-output-to-file	procedure)
(read	procedure)
(read-char	procedure)
(write	procedure)
(write-char	procedure))))

(define rnrs-arithmetic-flonums (private-process '(rnrs arithmetic flonums) '(
(&no-infinities	syntax)
(&no-nans	syntax)
(fixnum->flonum	procedure)
(fl*	procedure)
(fl+	procedure)
(fl-	procedure)
(fl/	procedure)
(fl<=?	procedure)
(fl<?	procedure)
(fl=?	procedure)
(fl>=?	procedure)
(fl>?	procedure)
(flabs	procedure)
(flacos	procedure)
(flasin	procedure)
(flatan	procedure)
(flceiling	procedure)
(flcos	procedure)
(fldenominator	procedure)
(fldiv	procedure)
(fldiv-and-mod	procedure)
(fldiv0	procedure)
(fldiv0-and-mod0	procedure)
(fleven?	procedure)
(flexp	procedure)
(flexpt	procedure)
(flfinite?	procedure)
(flfloor	procedure)
(flinfinite?	procedure)
(flinteger?	procedure)
(fllog	procedure)
(flmax	procedure)
(flmin	procedure)
(flmod	procedure)
(flmod0	procedure)
(flnan?	procedure)
(flnegative?	procedure)
(flnumerator	procedure)
(flodd?	procedure)
(flonum?	procedure)
(flpositive?	procedure)
(flround	procedure)
(flsin	procedure)
(flsqrt	procedure)
(fltan	procedure)
(fltruncate	procedure)
(flzero?	procedure)
(make-no-infinities-violation	procedure)
(make-no-nans-violation	procedure)
(no-infinities-violation?	procedure)
(no-nans-violation?	procedure)
(real->flonum	procedure))))

(define rnrs-arithmetic-bitwise (private-process '(rnrs arithmetic bitwise) '(
(bitwise-and	procedure)
(bitwise-arithmetic-shift	procedure)
(bitwise-arithmetic-shift-left	procedure)
(bitwise-arithmetic-shift-right	procedure)
(bitwise-bit-count	procedure)
(bitwise-bit-field	procedure)
(bitwise-bit-set?	procedure)
(bitwise-copy-bit	procedure)
(bitwise-copy-bit-field	procedure)
(bitwise-first-bit-set	procedure)
(bitwise-if	procedure)
(bitwise-ior	procedure)
(bitwise-length	procedure)
(bitwise-not	procedure)
(bitwise-reverse-bit-field	procedure)
(bitwise-rotate-bit-field	procedure)
(bitwise-xor	procedure))))

(define rnrs-arithmetic-fixnums (private-process '(rnrs arithmetic fixnums) '(
(fixnum-width	procedure)
(fixnum?	procedure)
(fx*/carry	procedure)
(fx+/carry	procedure)
(fx-/carry	procedure)
(fx<=?	procedure)
(fx<?	procedure)
(fx=?	procedure)
(fx>=?	procedure)
(fx>?	procedure)
(fxand	procedure)
(fxarithmetic-shift	procedure)
(fxarithmetic-shift-left	procedure)
(fxarithmetic-shift-right	procedure)
(fxbit-count	procedure)
(fxbit-field	procedure)
(fxbit-set?	procedure)
(fxcopy-bit	procedure)
(fxcopy-bit-field	procedure)
(fxdiv	procedure)
(fxdiv-and-mod	procedure)
(fxdiv0	procedure)
(fxdiv0-and-mod0	procedure)
(fxeven?	procedure)
(fxfirst-bit-set	procedure)
(fxif	procedure)
(fxior	procedure)
(fxlength	procedure)
(fxmax	procedure)
(fxmin	procedure)
(fxmod	procedure)
(fxmod0	procedure)
(fxnegative?	procedure)
(fxnot	procedure)
(fxodd?	procedure)
(fxpositive?	procedure)
(fxreverse-bit-field	procedure)
(fxrotate-bit-field	procedure)
(fxxor	procedure)
(fxzero?	procedure)
(greatest-fixnum	procedure)
(least-fixnum	procedure)
(fx*	procedure)
(fx+	procedure)
(fx-	procedure))))

(define rnrs-records-syntactic (private-process '(rnrs records syntactic) '(
(define-record-type	syntax)
(fields	syntax)
(immutable	syntax)
(mutable	syntax)
(nongenerative	syntax)
(opaque	syntax)
(parent	syntax)
(parent-rtd	syntax)
(protocol	syntax)
(record-constructor-descriptor	syntax)
(record-type-descriptor	procedure)
(sealed	syntax))))

(define rnrs-records-procedural (private-process '(rnrs records procedural) '(
(make-record-constructor-descriptor	procedure)
(make-record-type-descriptor	procedure)
(record-constructor	procedure)
(record-accessor	procedure)
(record-mutator	procedure)
(record-predicate	procedure)
(record-type-descriptor?	procedure)
)))

(define rnrs-records-inspection (private-process '(rnrs records inspection) '(
(record?	procedure)
(record-field-mutable?	procedure)
(record-rtd	procedure)
(record-type-field-names	procedure)
(record-type-generative?	procedure)
(record-type-name	procedure)
(record-type-opaque?	procedure)
(record-type-parent	procedure)
(record-type-sealed?	procedure)
(record-type-uid	procedure)
)))

(define chezscheme-csv7 (private-process '(chezscheme csv7) '(
(record-field-accessible?	procedure)
(record-field-accessor	procedure)
(record-field-mutable?	procedure)
(record-field-mutator	procedure)
(record-type-descriptor	procedure)
(record-type-field-decls	procedure)
(record-type-field-names	procedure)
(record-type-name	procedure)
(record-type-symbol	procedure)
)))

(define scheme-csv7 (private-process '(scheme csv7) '(
(record-field-accessible?	procedure)
(record-field-accessor	procedure)
(record-field-mutable?	procedure)
(record-field-mutator	procedure)
(record-type-descriptor	procedure)
(record-type-field-decls	procedure)
(record-type-field-names	procedure)
(record-type-name	procedure)
(record-type-symbol	procedure))))

(define scheme-base (private-process '(scheme base) '(
(define-library	syntax)
(* procedure)
(+ procedure)
(- procedure)
(... syntax)
(/ procedure)
(< procedure)
(<= procedure)
(= procedure)
(=> syntax)
(> procedure)
(>= procedure)
(_ syntax)
(abs procedure)
(and syntax)
(append procedure)
(apply procedure)
(assoc procedure)
(assq procedure)
(assv procedure)
(begin syntax)
(binary-port? procedure)
(boolean=? procedure)
(boolean? procedure)
(bytevector procedure)
(bytevector-append procedure)
(bytevector-copy procedure)
(bytevector-copy! procedure)
(bytevector-length procedure)
(bytevector-u8-ref procedure)
(bytevector-u8-set! procedure)
(bytevector? procedure)
(caar procedure)
(cadr procedure)
(call-with-current-continuation procedure)
(call-with-port procedure)
(call-with-values procedure)
(call/cc procedure)
(car procedure)
(case syntax)
(cdar procedure)
(cddr procedure)
(cdr procedure)
(ceiling procedure)
(char->integer procedure)
(char-ready? procedure)
(char<=? procedure)
(char<? procedure)
(char=? procedure)
(char>=? procedure)
(char>? procedure)
(char? procedure)
(close-input-port procedure)
(close-output-port procedure)
(close-port procedure)
(complex? procedure)
(cond syntax)
(cond-expand syntax)
(cons procedure)
(current-error-port procedure)
(current-input-port procedure)
(current-output-port procedure)
(define syntax)
(define-record-type syntax)
(define-syntax syntax)
(define-values syntax)
(denominator procedure)
(do syntax)
(dynamic-wind procedure)
(else syntax)
(eof-object procedure)
(eof-object? procedure)
(eq? procedure)
(equal? procedure)
(eqv? procedure)
(error procedure)
(error-object-irritants procedure)
(error-object-message procedure)
(error-object? procedure)
(even? procedure)
(exact procedure)
(exact-integer-sqrt procedure)
(exact-integer? procedure)
(exact? procedure)
(expt procedure)
(features procedure)
(file-error? procedure)
(floor procedure)
(floor-quotient procedure)
(floor-remainder procedure)
(floor/ procedure)
(flush-output-port procedure)
(for-each procedure)
(gcd procedure)
(get-output-bytevector procedure)
(get-output-string procedure)
(guard syntax)
(if syntax)
(import syntax)
(include syntax)
(include-ci syntax)
(inexact procedure)
(inexact? procedure)
(input-port-open? procedure)
(input-port? procedure)
(integer->char procedure)
(integer? procedure)
(lambda syntax)
(lcm procedure)
(length procedure)
(let syntax)
(let* syntax)
(let*-values syntax)
(let-syntax syntax)
(let-values syntax)
(letrec syntax)
(letrec* syntax)
(letrec-syntax syntax)
(list procedure)
(list->string procedure)
(list->vector procedure)
(list-copy procedure)
(list-ref procedure)
(list-set! procedure)
(list-tail procedure)
(list? procedure)
(make-bytevector procedure)
(make-list procedure)
(make-parameter procedure)
(make-string procedure)
(make-vector procedure)
(map procedure)
(max procedure)
(member procedure)
(memq procedure)
(memv procedure)
(min procedure)
(modulo procedure)
(negative? procedure)
(newline procedure)
(not procedure)
(null? procedure)
(number->string procedure)
(number? procedure)
(numerator procedure)
(odd? procedure)
(open-input-bytevector procedure)
(open-input-string procedure)
(open-output-bytevector procedure)
(open-output-string procedure)
(or syntax)
(output-port-open? procedure)
(output-port? procedure)
(pair? procedure)
(parameterize syntax)
(peek-char procedure)
(peek-u8 procedure)
(port? procedure)
(positive? procedure)
(procedure? procedure)
(quasiquote syntax)
(quote syntax)
(quotient procedure)
(raise procedure)
(raise-continuable procedure)
(rational? procedure)
(rationalize procedure)
(read-bytevector procedure)
(read-bytevector! procedure)
(read-char procedure)
(read-error? procedure)
(read-line procedure)
(read-string procedure)
(read-u8 procedure)
(real? procedure)
(remainder procedure)
(reverse procedure)
(round procedure)
(set! syntax)
(set-car! procedure)
(set-cdr! procedure)
(square procedure)
(string procedure)
(string->list procedure)
(string->number procedure)
(string->symbol procedure)
(string->utf8 procedure)
(string->vector procedure)
(string-append procedure)
(string-copy procedure)
(string-copy! procedure)
(string-fill! procedure)
(string-for-each procedure)
(string-length procedure)
(string-map procedure)
(string-ref procedure)
(string-set! procedure)
(string<=? procedure)
(string<? procedure)
(string=? procedure)
(string>=? procedure)
(string>? procedure)
(string? procedure)
(substring procedure)
(symbol->string procedure)
(symbol=? procedure)
(symbol? procedure)
(syntax-error syntax)
(syntax-rules syntax)
(textual-port? procedure)
(truncate procedure)
(truncate-quotient procedure)
(truncate-remainder procedure)
(truncate/ procedure)
(u8-ready? procedure)
(unless syntax)
(unquote syntax)
(unquote-splicing syntax)
(utf8->string procedure)
(values procedure)
(vector procedure)
(vector->list procedure)
(vector->string procedure)
(vector-append procedure)
(vector-copy procedure)
(vector-copy! procedure)
(vector-fill! procedure)
(vector-for-each procedure)
(vector-length procedure)
(vector-map procedure)
(vector-ref procedure)
(vector-set! procedure)
(vector? procedure)
(when syntax)
(with-exception-handler procedure)
(write-bytevector procedure)
(write-char procedure)
(write-string procedure)
(write-u8 procedure)
(zero? procedure)
) 'r7rs))

(define scheme-case-lambda (private-process '(scheme case lambda) '( 
(case-lambda syntax)
) 'r7rs))

(define scheme-char (private-process '(scheme char) '( 
(char-alphabetic? procedure)
(char-ci<=? procedure)
(char-ci<? procedure)
(char-ci=? procedure)
(char-ci>=? procedure)
(char-ci>? procedure)
(char-downcase procedure)
(char-foldcase procedure)
(char-lower-case? procedure)
(char-numeric? procedure)
(char-upcase procedure)
(char-upper-case? procedure)
(char-whitespace? procedure)
(digit-value procedure)
(string-ci<=? procedure)
(string-ci<? procedure)
(string-ci=? procedure)
(string-ci>=? procedure)
(string-ci>? procedure)
(string-downcase procedure)
(string-foldcase procedure)
(string-upcase procedure)
) 'r7rs))

(define scheme-complex (private-process '(scheme complex) '( 
(angle procedure)
(imag-part procedure)
(magnitude procedure)
(make-polar procedure)
(make-rectangular procedure)
(real-part procedure)
) 'r7rs))

(define scheme-cxr (private-process '(scheme cxr) '( 
(caaaar procedure)
(caaadr procedure)
(caaar procedure)
(caadar procedure)
(caaddr procedure)
(caadr procedure)
(cadaar procedure)
(cadadr procedure)
(cadar procedure)
(caddar procedure)
(cadddr procedure)
(caddr procedure)
(cdaaar procedure)
(cdaadr procedure)
(cdaar procedure)
(cdadar procedure)
(cdaddr procedure)
(cdadr procedure)
(cddaar procedure)
(cddadr procedure)
(cddar procedure)
(cdddar procedure)
(cddddr procedure)
(cdddr procedure)
) 'r7rs))

(define scheme-eval (private-process '(scheme eval) '( 
(environment procedure)
(eval procedure)
) 'r7rs))

(define scheme-file (private-process '(scheme file) '( 
(call-with-input-file procedure)
(call-with-output-file procedure)
(delete-file procedure)
(file-exists? procedure)
(open-binary-input-file procedure)
(open-binary-output-file procedure)
(open-input-file procedure)
(open-output-file procedure)
(with-input-from-file procedure)
(with-output-to-file procedure)
) 'r7rs))

(define scheme-inexact (private-process '(scheme inexact) '( 
(acos procedure)
(asin procedure)
(atan procedure)
(cos procedure)
(exp procedure)
(finite? procedure)
(infinite? procedure)
(log procedure)
(nan? procedure)
(sin procedure)
(sqrt procedure)
(tan procedure)
) 'r7rs))

(define scheme-lazy (private-process '(scheme lazy) '( 
(delay syntax)
(delay-force syntax)
(force procedure)
(make-promise procedure)
(promise? procedure)
) 'r7rs))

(define scheme-load (private-process '(scheme load) '( 
(load procedure)
) 'r7rs))

(define scheme-process-context (private-process '(scheme process context) '( 
(command-line procedure)
(emergency-exit procedure)
(exit procedure)
(get-environment-variable procedure)
(get-environment-variables procedure)
) 'r7rs))

(define scheme-read (private-process '(scheme read) '( 
(read procedure)
) 'r7rs))

(define scheme-repl (private-process '(scheme repl) '( 
(interaction-environment procedure)
) 'r7rs))

(define scheme-time (private-process '(scheme time) '( 
(current-jiffy procedure)
(current-second procedure)
(jiffies-per-second procedure)
) 'r7rs))

(define scheme-write (private-process '(scheme write) '( 
(display procedure)
(write procedure)
(write-shared procedure)
(write-simple procedure)
) 'r7rs))

(define scheme-r5rs (private-process '(scheme r5rs) '( 
(* procedure)
(+ procedure)
(- procedure)
(... syntax)
(/ procedure)
(< procedure)
(<= procedure)
(= procedure)
(=> syntax)
(> procedure)
(>= procedure)
(_ syntax)
(abs procedure)
(acos procedure)
(and syntax)
(angle procedure)
(append procedure)
(apply procedure)
(asin procedure)
(assoc procedure)
(assq procedure)
(assv procedure)
(atan procedure)
(begin syntax)
(boolean? procedure)
(caaaar procedure)
(caaadr procedure)
(caaar procedure)
(caadar procedure)
(caaddr procedure)
(caadr procedure)
(caar procedure)
(cadaar procedure)
(cadadr procedure)
(cadar procedure)
(caddar procedure)
(cadddr procedure)
(caddr procedure)
(cadr procedure)
(call-with-current-continuation procedure)
(call-with-input-file procedure)
(call-with-output-file procedure)
(call-with-values procedure)
(car procedure)
(case syntax)
(cdaaar procedure)
(cdaadr procedure)
(cdaar procedure)
(cdadar procedure)
(cdaddr procedure)
(cdadr procedure)
(cdar procedure)
(cddaar procedure)
(cddadr procedure)
(cddar procedure)
(cdddar procedure)
(cddddr procedure)
(cdddr procedure)
(cddr procedure)
(cdr procedure)
(ceiling procedure)
(char->integer procedure)
(char-alphabetic? procedure)
(char-ci<=? procedure)
(char-ci<? procedure)
(char-ci=? procedure)
(char-ci>=? procedure)
(char-ci>? procedure)
(char-downcase procedure)
(char-lower-case? procedure)
(char-numeric? procedure)
(char-ready? procedure)
(char-upcase procedure)
(char-upper-case? procedure)
(char-whitespace? procedure)
(char<=? procedure)
(char<? procedure)
(char=? procedure)
(char>=? procedure)
(char>? procedure)
(char? procedure)
(close-input-port procedure)
(close-output-port procedure)
(complex? procedure)
(cond syntax)
(cons procedure)
(cos procedure)
(current-input-port procedure)
(current-output-port procedure)
(define syntax)
(define-syntax syntax)
(delay syntax)
(denominator procedure)
(display procedure)
(do syntax)
(dynamic-wind procedure)
(else syntax)
(eof-object? procedure)
(eq? procedure)
(equal? procedure)
(eqv? procedure)
(eval procedure)
(even? procedure)
(exact->inexact procedure)
(exact? procedure)
(exp procedure)
(expt procedure)
(floor procedure)
(for-each procedure)
(force procedure)
(gcd procedure)
(if syntax)
(imag-part procedure)
(inexact->exact procedure)
(inexact? procedure)
(input-port? procedure)
(integer->char procedure)
(integer? procedure)
(interaction-environment procedure)
(lambda syntax)
(lcm procedure)
(length procedure)
(let syntax)
(let* syntax)
(let-syntax syntax)
(letrec syntax)
(letrec-syntax syntax)
(list procedure)
(list->string procedure)
(list->vector procedure)
(list-ref procedure)
(list-tail procedure)
(list? procedure)
(load procedure)
(log procedure)
(magnitude procedure)
(make-polar procedure)
(make-rectangular procedure)
(make-string procedure)
(make-vector procedure)
(map procedure)
(max procedure)
(member procedure)
(memq procedure)
(memv procedure)
(min procedure)
(modulo procedure)
(negative? procedure)
(newline procedure)
(not procedure)
(null-environment procedure)
(null? procedure)
(number->string procedure)
(number? procedure)
(numerator procedure)
(odd? procedure)
(open-input-file procedure)
(open-output-file procedure)
(or syntax)
(output-port? procedure)
(pair? procedure)
(peek-char procedure)
(positive? procedure)
(procedure? procedure)
(quasiquote syntax)
(quote syntax)
(quotient procedure)
(rational? procedure)
(rationalize procedure)
(read procedure)
(read-char procedure)
(real-part procedure)
(real? procedure)
(remainder procedure)
(reverse procedure)
(round procedure)
(scheme-report-environment procedure)
(set! syntax)
(set-car! procedure)
(set-cdr! procedure)
(sin procedure)
(sqrt procedure)
(string procedure)
(string->list procedure)
(string->number procedure)
(string->symbol procedure)
(string-append procedure)
(string-ci<=? procedure)
(string-ci<? procedure)
(string-ci=? procedure)
(string-ci>=? procedure)
(string-ci>? procedure)
(string-copy procedure)
(string-fill! procedure)
(string-length procedure)
(string-ref procedure)
(string-set! procedure)
(string<=? procedure)
(string<? procedure)
(string=? procedure)
(string>=? procedure)
(string>? procedure)
(string? procedure)
(substring procedure)
(symbol->string procedure)
(symbol? procedure)
(syntax-rules syntax)
(tan procedure)
(truncate procedure)
(values procedure)
(vector procedure)
(vector->list procedure)
(vector-fill! procedure)
(vector-length procedure)
(vector-ref procedure)
(vector-set! procedure)
(vector? procedure)
(with-input-from-file procedure)
(with-output-to-file procedure)
(write procedure)
(write-char procedure)
(zero? procedure)
) 'r7rs))

(define s7 (private-process '(s7) '(
(* procedure)
(*function* procedure)
(+ procedure)
(- procedure)
(/ procedure)
(< procedure)
(<= procedure)
(= procedure)
(=> syntax)
(> procedure)
(>= procedure)
(abs procedure)
(acos procedure)
(acosh procedure)
(and syntax)
(angle procedure)
(append procedure)
(apply procedure)
(apply-values procedure)
(aritable? procedure)
(arity procedure)
(ash procedure)
(asin procedure)
(asinh procedure)
(assoc procedure)
(assq procedure)
(assv procedure)
(atan procedure)
(atanh procedure)
(autoload procedure)
(bacro syntax)
(bacro* syntax)
(begin syntax)
(bignum procedure)
(bignum? procedure)
(boolean? procedure)
(byte-vector procedure)
(byte-vector->string procedure)
(byte-vector-ref procedure)
(byte-vector-set! procedure)
(byte-vector? procedure)
(byte? procedure)
(c-object-let procedure)
(c-object-type procedure)
(c-object? procedure)
(c-pointer procedure)
(c-pointer->list procedure)
(c-pointer-info procedure)
(c-pointer-type procedure)
(c-pointer-weak1 procedure)
(c-pointer-weak2 procedure)
(c-pointer? procedure)
(caaaar procedure)
(caaadr procedure)
(caaar procedure)
(caadar procedure)
(caaddr procedure)
(caadr procedure)
(caar procedure)
(cadaar procedure)
(cadadr procedure)
(cadar procedure)
(caddar procedure)
(cadddr procedure)
(caddr procedure)
(cadr procedure)
(call-with-current-continuation procedure)
(call-with-exit procedure)
(call-with-input-file procedure)
(call-with-input-string procedure)
(call-with-output-file procedure)
(call-with-output-string procedure)
(call/cc procedure)
(car procedure)
(case syntax)
(catch procedure)
(cdaaar procedure)
(cdaadr procedure)
(cdaar procedure)
(cdadar procedure)
(cdaddr procedure)
(cdadr procedure)
(cdar procedure)
(cddaar procedure)
(cddadr procedure)
(cddar procedure)
(cdddar procedure)
(cddddr procedure)
(cdddr procedure)
(cddr procedure)
(cdr procedure)
(ceiling procedure)
(char->integer procedure)
(char-alphabetic? procedure)
(char-ci<=? procedure)
(char-ci<? procedure)
(char-ci=? procedure)
(char-ci>=? procedure)
(char-ci>? procedure)
(char-downcase procedure)
(char-lower-case? procedure)
(char-numeric? procedure)
(char-position procedure)
(char-ready? procedure)
(char-upcase procedure)
(char-upper-case? procedure)
(char-whitespace? procedure)
(char<=? procedure)
(char<? procedure)
(char=? procedure)
(char>=? procedure)
(char>? procedure)
(char? procedure)
(close-input-port procedure)
(close-output-port procedure)
(complex procedure)
(complex-vector procedure)
(complex-vector-ref procedure)
(complex-vector-set! procedure)
(complex-vector? procedure)
(complex? procedure)
(cond syntax)
(cons procedure)
(constant? procedure)
(continuation? procedure)
(copy procedure)
(cos procedure)
(cosh procedure)
(coverlet procedure)
(curlet procedure)
(current-error-port procedure)
(current-input-port procedure)
(current-output-port procedure)
(cutlet procedure)
(cyclic-sequences procedure)
(define syntax)
(define* syntax)
(define-bacro syntax)
(define-bacro* syntax)
(define-constant syntax)
(define-expansion syntax)
(define-expansion* syntax)
(define-library	syntax)
(define-macro syntax)
(define-macro* syntax)
(defined? procedure)
(delete-file procedure)
(denominator procedure)
(dilambda procedure)
(dilambda? procedure)
(directory->list procedure)
(directory? procedure)
(display procedure)
(display procedure)
(do syntax)
(documentation procedure)
(dynamic-unwind procedure)
(dynamic-wind procedure)
(else syntax)
(emergency-exit procedure)
(eof-object? procedure)
(eq? procedure)
(equal? procedure)
(equivalent? procedure)
(eqv? procedure)
(error procedure)
(eval procedure)
(eval-string procedure)
(even? procedure)
(exact->inexact procedure)
(exact? procedure)
(exit procedure)
(exp procedure)
(expt procedure)
(file-exists? procedure)
(file-mtime procedure)
(fill! procedure)
(float-vector procedure)
(float-vector-ref procedure)
(float-vector-set! procedure)
(float-vector? procedure)
(float? procedure)
(floor procedure)
(flush-output-port procedure)
(for-each procedure)
(format procedure)
(funclet procedure)
(funclet? procedure)
(gc procedure)
(gcd procedure)
(gensym procedure)
(gensym? procedure)
(get-output-string procedure)
(getenv procedure)
(goto? procedure)
(hash-code procedure)
(hash-table procedure)
(hash-table-entries procedure)
(hash-table-key-typer procedure)
(hash-table-ref procedure)
(hash-table-set! procedure)
(hash-table-value-typer procedure)
(hash-table? procedure)
(help procedure)
(if syntax)
(if syntax)
(imag-part procedure)
(immutable! procedure)
(immutable? procedure)
(import syntax)
(inexact->exact procedure)
(inexact? procedure)
(infinite? procedure)
(inlet procedure)
(input-port? procedure)
(int-vector procedure)
(int-vector-ref procedure)
(int-vector-set! procedure)
(int-vector? procedure)
(integer->char procedure)
(integer-decode-float procedure)
(integer-length procedure)
(integer:any? procedure)
(integer:number? procedure)
(integer:real? procedure)
(integer? procedure)
(iterate procedure)
(iterator-at-end? procedure)
(iterator-sequence procedure)
(iterator? procedure)
(keyword->symbol procedure)
(keyword? procedure)
(lambda syntax)
(lambda* syntax)
(lcm procedure)
(length procedure)
(let syntax)
(let* syntax)
(let->list procedure)
(let-ref procedure)
(let-ref-fallback procedure)
(let-set! procedure)
(let-set-fallback procedure)
(let-temporarily syntax)
(let? procedure)
(letrec syntax)
(letrec* syntax)
(list procedure)
(list->string procedure)
(list->vector procedure)
(list-ref procedure)
(list-set! procedure)
(list-tail procedure)
(list-values procedure)
(list? procedure)
(load procedure)
(log procedure)
(logand procedure)
(logbit? procedure)
(logior procedure)
(lognot procedure)
(logxor procedure)
(macro syntax)
(macro* syntax)
(macro? procedure)
(macroexpand syntax)
(magnitude procedure)
(make-byte-vector procedure)
(make-complex-vector procedure)
(make-float-vector procedure)
(make-hash-table procedure)
(make-int-vector procedure)
(make-iterator procedure)
(make-list procedure)
(make-polar procedure)
(make-string procedure)
(make-vector procedure)
(make-weak-hash-table procedure)
(map procedure)
(max procedure)
(member procedure)
(memq procedure)
(memv procedure)
(min procedure)
(modulo procedure)
(nan procedure)
(nan-payload procedure)
(nan? procedure)
(negative? procedure)
(newline procedure)
(not procedure)
(null? procedure)
(number->string procedure)
(number? procedure)
(numerator procedure)
(object->let procedure)
(object->string procedure)
(odd? procedure)
(open-input-file procedure)
(open-input-function procedure)
(open-input-string procedure)
(open-output-file procedure)
(open-output-function procedure)
(open-output-string procedure)
(openlet procedure)
(openlet? procedure)
(or syntax)
(outlet procedure)
(output-port? procedure)
(owlet procedure)
(pair-filename procedure)
(pair-line-number procedure)
(pair? procedure)
(peek-char procedure)
(port-closed? procedure)
(port-file procedure)
(port-filename procedure)
(port-line-number procedure)
(port-position procedure)
(port-string procedure)
(positive? procedure)
(procedure-arglist procedure)
(procedure-source procedure)
(procedure? procedure)
(proper-list? procedure)
(provide procedure)
(provided? procedure)
(quote syntax)
(quotient procedure)
(random procedure)
(random-state procedure)
(random-state->list procedure)
(random-state? procedure)
(rational? procedure)
(rationalize procedure)
(read procedure)
(read-byte procedure)
(read-char procedure)
(read-line procedure)
(read-string procedure)
(real-part procedure)
(real? procedure)
(remainder procedure)
(reverse procedure)
(reverse! procedure)
(rootlet procedure)
(round procedure)
(sequence? procedure)
(set! syntax)
(set-car! procedure)
(set-cdr! procedure)
(set-current-error-port procedure)
(set-current-input-port procedure)
(set-current-output-port procedure)
(setter procedure)
(signature procedure)
(sin procedure)
(sinh procedure)
(sort! procedure)
(sqrt procedure)
(stacktrace procedure)
(string procedure)
(string->byte-vector procedure)
(string->keyword procedure)
(string->list procedure)
(string->number procedure)
(string->symbol procedure)
(string-append procedure)
(string-ci<=? procedure)
(string-ci<? procedure)
(string-ci=? procedure)
(string-ci>=? procedure)
(string-ci>? procedure)
(string-copy procedure)
(string-downcase procedure)
(string-fill! procedure)
(string-length procedure)
(string-position procedure)
(string-ref procedure)
(string-set! procedure)
(string-upcase procedure)
(string<=? procedure)
(string<? procedure)
(string=? procedure)
(string>=? procedure)
(string>? procedure)
(string? procedure)
(sublet procedure)
(substring procedure)
(substring-uncopied procedure)
(subvector procedure)
(subvector-position procedure)
(subvector-vector procedure)
(subvector? procedure)
(symbol procedure)
(symbol->dynamic-value procedure)
(symbol->keyword procedure)
(symbol->string procedure)
(symbol->value procedure)
(symbol-initial-value procedure)
(symbol-table procedure)
(symbol? procedure)
(syntax-error syntax)
(syntax? procedure)
(system procedure)
(tan procedure)
(tanh procedure)
(throw procedure)
(truncate procedure)
(type-of procedure)
(undefined? procedure)
(unless syntax)
(unlet procedure)
(unquote syntax)
(unspecified? procedure)
(values procedure)
(values procedure)
(varlet procedure)
(vector procedure)
(vector->list procedure)
(vector-append procedure)
(vector-dimension procedure)
(vector-dimensions procedure)
(vector-fill! procedure)
(vector-length procedure)
(vector-rank procedure)
(vector-ref procedure)
(vector-set! procedure)
(vector-typer procedure)
(vector? procedure)
(weak-hash-table procedure)
(weak-hash-table? procedure)
(when syntax)
(with-baffle syntax)
(with-input-from-file procedure)
(with-input-from-string procedure)
(with-let syntax)
(with-output-to-file procedure)
(with-output-to-string procedure)
(write procedure)
(write procedure)
(write-byte procedure)
(write-char procedure)
(write-string procedure)
(zero? procedure)
) 's7))

)
