;; -*- mode: scheme; coding: utf-8 -*-
;; Copyright (c) 2023 
;; SPDX-License-Identifier: MIT
#!r6rs

(library (vterm events)
  (export
    make-vterm-glyph-event
    vterm-glyph-event?
    vterm-glyph-event=?
    vterm-glyph-event-pos
    vterm-glyph-event-char
    vterm-glyph-event-char-set!
    vterm-glyph-event-width
    vterm-glyph-event-width-set!

    make-vterm-scroll-event
    vterm-scroll-event?
    vterm-scroll-event-rect
    vterm-scroll-event-downward
    vterm-scroll-event-downward-set!
    vterm-scroll-event-rightward
    vterm-scroll-event-rightward-set!

    make-vterm-erase-event
    vterm-erase-event?
    vterm-erase-event-rect
    vterm-erase-event-selective?
    vterm-erase-event-selective?-set!

    make-vterm-line-info-event
    vterm-line-info-event?
    vterm-line-info-event-state

    make-vterm-cursor-event
    vterm-cursor-event?
    vterm-cursor-event-new-pos
    vterm-cursor-event-old-pos
    vterm-cursor-event-visible?
    vterm-cursor-event-visible?-set!

    make-vterm-property-event
    vterm-property-event?
    vterm-property-event-symbol
    vterm-property-event-value

    make-vterm-damage-event
    vterm-damage-event?
    vterm-damage-event-rect

    make-vterm-move-event
    vterm-move-event?
    vterm-move-event-src
    vterm-move-event-dst

    make-vterm-style-event
    vterm-style-event?
    vterm-style-event-fg
    vterm-style-event-fg-set!
    vterm-style-event-bg
    vterm-style-event-bg-set!
    vterm-style-event-attr
    vterm-style-event-attr-set!

    make-vterm-resize-event
    vterm-resize-event?
    vterm-resize-event-new-rows
    vterm-resize-event-new-cols
    vterm-resize-event-delta

    make-vterm-pop-line-event
    vterm-pop-line-event?
    vterm-pop-line-event-cells
    vterm-pop-line-event-has-more?
    vterm-pop-line-event-has-more?-set!

    make-vterm-push-line-event
    vterm-push-line-event?
    vterm-push-line-event-cells

    make-vterm-control-event
    vterm-control-event?
    vterm-control-event-code)
  (import (rnrs)
          (vterm common))

(define-record-type vterm-damage-event
  (fields rect))

(define-record-type vterm-move-event
  (fields src dst))

(define-record-type vterm-glyph-event
  (fields (mutable char) (mutable width) pos))

(define vterm-glyph-event=?
  (case-lambda
    [(ev1 ev2)
     (and (eqv? (vterm-glyph-event-char ev1) (vterm-glyph-event-char ev2))
          (eqv? (vterm-glyph-event-width ev1) (vterm-glyph-event-char ev2))
          (vterm-pos=? (vterm-glyph-event-pos ev1) (vterm-glyph-event-pos ev2)))]
    [(ev char width col row)
     (vterm-glyph-event=? ev (make-vterm-glyph-event char width (make-vterm-pos row col)))]
))

(define-record-type vterm-cursor-event
  (fields new-pos old-pos (mutable visible?)))

(define-record-type vterm-scroll-event
  (fields rect (mutable downward) (mutable rightward)))

(define-record-type vterm-erase-event
  (fields rect (mutable selective?)))

(define-record-type vterm-property-event
  (fields symbol value))

(define-record-type vterm-bell-event)

(define-record-type vterm-resize-event
  (fields new-rows new-cols delta))

(define-record-type vterm-line-info-event
  (fields state))

(define-record-type vterm-style-event
  (fields (mutable fg) (mutable bg) (mutable attr)))

(define-record-type vterm-pop-line-event
  (fields cells (mutable has-more?)))

(define-record-type vterm-push-line-event
  (fields cells))

(define-record-type vterm-control-event
  (fields code))

)
