;; -*- mode: scheme; coding: utf-8 -*-
;; Copyright (c) 2023 
;; SPDX-License-Identifier: MIT
#!r6rs

(library (vterm style)
  (export
    make-vterm-style
    vterm-style?
    vterm-style=?
    vterm-style-fg
    vterm-style-fg-set!
    vterm-style-bg
    vterm-style-bg-set!
    vterm-style-attr
    vterm-style-attr-set!

    vterm-style-attr-on!
    vterm-style-attr-off!
    vterm-style-attr-set?
    vterm-style-attrs-set?
    vterm-style-attr-reset!

    Vterm-Bold Vterm-Underline Vterm-Italic Vterm-Blink Vterm-Reverse Vterm-Strike

    Vterm-Default
    Vterm-Black Vterm-Blue Vterm-Green Vterm-Cyan Vterm-Red Vterm-Magenta Vterm-Brown Vterm-Gray
    Vterm-DarkGray Vterm-LightBlue Vterm-LightGreen Vterm-LightCyan Vterm-LightRed Vterm-LightMagenta
    Vterm-Yellow Vterm-White
    Vterm-Orange)
  (import (rnrs)
          (text-mode console model))

(define Vterm-Black   Black)
(define Vterm-Blue    Blue)
(define Vterm-Green   Green)
(define Vterm-Cyan    Cyan)
(define Vterm-Red     Red)
(define Vterm-Magenta Magenta)
(define Vterm-Brown   Brown)
(define Vterm-Gray    Gray)
(define Vterm-DarkGray DarkGray)
(define Vterm-LightBlue  LightBlue)
(define Vterm-LightGreen LightGreen)
(define Vterm-LightCyan  LightCyan)
(define Vterm-LightRed     LightRed)
(define Vterm-LightMagenta LightMagenta)
(define Vterm-Yellow       Yellow)
(define Vterm-White        White)
(define Vterm-Orange       Orange)
(define Vterm-Default      Default)

(define Vterm-Bold 0)
(define Vterm-Underline 1)
(define Vterm-Italic 2)
(define Vterm-Blink 3)
(define Vterm-Reverse 4)
(define Vterm-Strike 5)

(define-record-type (vterm-style $make-vterm-style vterm-style?)
  (fields
    (mutable fg)
    (mutable bg)
    (mutable attr)))

(define make-vterm-style
  (case-lambda
    [() ($make-vterm-style Vterm-Gray Vterm-Black (make-vector 7 #f))]
    [(fg bg) ($make-vterm-style fg bg (make-vector 7 #f))]
    [(fg bg attr) ($make-vterm-style fg bg attr)]))

(define (vterm-style=? s1 s2)
  (and (eqv? (vterm-style-fg s1) (vterm-style-fg s2))
       (eqv? (vterm-style-bg s1) (vterm-style-bg s2))
       (equal? (vterm-style-attr s1) (vterm-style-attr s2))))

(define (vterm-style-attr-on! style attr)
  (vector-set! (vterm-style-attr style) attr #t))

(define (vterm-style-attr-off! style attr)
  (vector-set! (vterm-style-attr style) attr #f))

(define (vterm-style-attr-set? style attr)
  (vector-ref (vterm-style-attr style) attr))

(define (vterm-style-attrs-set? style attrs)
  (for-all (lambda (attr)
             (vterm-style-attr-set? style attr))
    attrs))

(define (vterm-style-attr-reset! style)
  (do ([i 0 (fx+ i 1)]) ((fx=? i 7))
    (vector-set! (vterm-style-attr style) i #f)))

)
