;; -*- mode: scheme; coding: utf-8 -*-
;; Copyright (c) 2023 
;; SPDX-License-Identifier: MIT
#!r6rs

(library (vterm utils)
  (export
    vector-copy!
    vector-move!)
  (import (rnrs))

(define vector-copy!
  (case-lambda
    [(src src-idx dst dst-idx num)
     (vector-copy! src src-idx dst dst-idx num #f) ]
    [(src src-idx dst dst-idx num copy-fn)
     (do ([i 0 (fx+ i 1)]) ((fx=? i num))
       (let ([src-i (fx+ src-idx i)]
             [dst-i (fx+ dst-idx i)])
         (if copy-fn
             (copy-fn src src-i dst dst-i)
             (vector-set! dst dst-i (vector-ref src src-i)))))]))

(define vector-move!
  (case-lambda
    [(vec from-idx to-idx num)
     (vector-move! vec from-idx to-idx num #f)]

    [(vec from-idx to-idx num copy-fn)
     (when (not (fx=? to-idx from-idx))
       (let ([tmp (make-vector num)])
         (vector-copy! vec from-idx tmp 0 num copy-fn)
         (vector-copy! tmp 0 vec to-idx num #f)
         ))]))

)
